<%@page pageEncoding="UTF-8" contentType="text/html; charset=UTF-8"%>

<%@taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<div class="modal fade" id="modalFichaMaterialPromocional">
	<form id="formFichaMaterialPromocional" method="post" class="form-horizontal">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close notDisabled" id="btnCerrarMatPromo" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title"><spring:message code="catalogo.fichaMaterialPromocional" /></h4>
				</div>
				<div class="modal-body">
					<div class="alertPanel" id="divAlertFichaMaterialPromoModal"></div>
					<div class="panel panel-default">
						  <div class="panel-heading"><label><spring:message code="catalogo.datosMaterial" /></label></div>
						  <div class="panel-body">
								<div class="row">
									<div class="col-sm-3 col-xs-12 form-group">
										<label class="checkbox-inline"><input type="checkbox" id="descatalogadoMP"  name="descatalogado" value="S"><spring:message code="catalogo.descatalogado" /></label>
									</div>
									<div class="col-sm-3 col-xs-12 form-group ocultar" id="divFechaDescatalogadoMP">
										<label class="labelGroupRadio"><spring:message code="catalogo.fecha" /></label>
										<div class="input-group date">
											<input type="text" class="form-control campoFecha" id="fechaDescatalogadoMP"  name="fechaDescatalogado" />
											<div class="input-group-addon calendarioFecha"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></div>
										</div>
									</div>
								</div>

								<div class="row">
									<div class="col-xs-12 form-group">
										<label><spring:message code="catalogo.tituloCastellano" /></label>
										<input type="text" class="form-control" id="tituloCastellanoMP" name="tituloCastellano"  maxlength="100"/>
									</div>
								</div><!-- fin fila -->

								<div class="row">
									<div class="col-xs-12 form-group">
										<label><spring:message code="catalogo.tituloEuskera" /></label>
										<input type="text" class="form-control" id="tituloEuskeraMP" name="tituloEuskera"  maxlength="100"/>
									</div>
								</div><!-- fin fila -->

								<div class="row">
									<div class="col-sm-6 col-xs-12 form-group">
										<label><spring:message code="catalogo.codigoAlmacen" /></label>
										<input type="text" class="form-control" id="codigoAlmacenMP"  name="articuloPromocional.codigoAlmacen"  maxlength="10"/>
									</div>
								</div><!-- fin fila -->

								<div class="row">
									<div class="col-sm-6 col-xs-12 form-group">
										<label><spring:message code="catalogo.stock" /></label>
										<input type="text" class="form-control campoNumerico" id="stockMP"  name="articuloPromocional.stock" data-v-max="999999" maxlength="6" />
									</div>

									<div class="col-sm-6 col-xs-12 form-group">
										<label><spring:message code="catalogo.minimo" /></label>
										<input type="text" class="form-control campoNumerico" id="stockMinMP"  name="articuloPromocional.stockMin" data-v-max="999999" maxlength="6" />
									</div>
								</div><!-- fin fila -->

								<div class="panel panel-default">
						<div class="panel-heading"><label><spring:message code="catalogo.datosNecesarios" /></label></div>
						<div class="panel-body">
							<div class="row">
								<div class="col-xs-12 form-group">
									<label class="radio-inline"><input type="radio" id="modoPeticionE_MP" name="articuloPromocional.modoPeticion" value="E" /><spring:message code="catalogo.solicitudEjemplar" /></label>
									<label class="radio-inline"><input type="radio" id="modoPeticionC_MP" name="articuloPromocional.modoPeticion" value="C" /><spring:message code="catalogo.solicitudCajas" /></label>
								</div>
							</div><!-- fin fila -->

							<div class="panel panel-default" id="divEjemplaresMP">
								<div class="panel-heading"><label><spring:message code="catalogo.ejemplar" /></label></div>
								<div class="panel-body">
									<div class="row">
										<div class="col-sm-6 col-xs-12 form-group">
											<label><spring:message code="catalogo.minimoEjemplares" /></label>
											<input type="text" class="form-control campoNumerico" id="numMinimoEMP" name="articuloPromocional.numMinimo" data-v-max="999999" maxlength="6" />
										</div>
										<div class="col-sm-6 col-xs-12 form-group">
											<label><spring:message code="catalogo.formaEnvio" /></label>
													<form:select class="form-control" path="idioma" id="codigoFormaEnvioEMP" name="articuloPromocional.codigoFormaEnvio">
														<form:option value="" label="" />
														<form:options items="${formasEnvio}" />
													</form:select>
										</div>
									</div><!-- fin fila -->
								</div>
							</div>

							<div class="panel panel-default ocultar" id="divCajasMP">
								<div class="panel-heading"><label><spring:message code="catalogo.cajas" /></label></div>
								<div class="panel-body">
									<div class="row">
										<div class="col-sm-6 col-xs-12 form-group">
											<label><spring:message code="catalogo.ejemplaresCaja" /></label>
											<input type="text" class="form-control campoNumerico" id="numEjemplaresMP" name="articuloPromocional.numEjemplares" data-v-max="999999" maxlength="6" />
										</div>
										<div class="col-sm-6 col-xs-12 form-group">
											<label><spring:message code="catalogo.minimoCajas" /></label>
											<input type="text" class="form-control campoNumerico" id="numMinimoCMP" name="articuloPromocional.numMinimo" data-v-max="999999" maxlength="6" />
										</div>
									</div>
									<div class="row">
										<div class="col-sm-6 col-xs-12 form-group">
											<label><spring:message code="catalogo.formaEnvio" /></label>
											<form:select class="form-control" path="idioma" id="codigoFormaEnvioCMP" name="articuloPromocional.codigoFormaEnvio">
												<form:option value="" label="" />
												<form:options items="${formasEnvio}" />
											</form:select>
										</div>
									</div><!-- fin fila -->
								</div>
							</div>

						</div>
					</div>


							</div>
						</div>
				</div>
				<div class="modal-footer">
					<button class="btn btn-light notDisabled" type="button" id="btnCancelarMatPromo"><spring:message code="formulario.botonCancelar" /></button>
					<button class="btn btn-green" type="submit" id="btnAceptarMatPromo"><spring:message code="formulario.botonAceptar" /></button>
				</div>
			</div><!-- /.modal-content -->
		</div><!-- /.modal-dialog -->
		<input type="hidden" class="form-control" readonly="readonly" id="codigoTipoMP" name="codigoTipoMaterial" />
		<input type="hidden" class="form-control" readonly="readonly" id="codigoMaterialMP" name="codigoMaterial" />
		<input type="hidden" class="form-control" readonly="readonly" id="codArticuloMP" name="articuloPromocional.codArticulo" />
	</form>
</div><!-- /.modal -->
