<%@page pageEncoding="UTF-8" contentType="text/html; charset=UTF-8"%>

<%@taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@taglib prefix="form" uri="http://www.springframework.org/tags/form" %>

<div class="modal fade" id="modalFichaMaterial">
	<form id="formFichaMaterial" method="post" class="form-horizontal">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close notDisabled" id="btnCerrarFolleto"  aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title"><spring:message code="catalogo.fichaFolleto" /></h4>
				</div>
				
				<div class="modal-body">
					<div class="alertPanel" id="divAlertFichaMaterialModal"></div>
					<div class="panel panel-default">
						  <div class="panel-heading"><label><spring:message code="catalogo.datosMaterial" /></label></div>
						  <div class="panel-body">
								<div class="row">
									<div class="col-sm-3 col-xs-12 form-group">
										<label class="checkbox-inline"><input type="checkbox" id="descatalogado"  name="descatalogado" value="S"><spring:message code="catalogo.descatalogado" /></label>
									</div>
									<div class="col-sm-3 col-xs-12 form-group ocultar" id="divFechaDescatalogado">
										<label class="labelGroupRadio"><spring:message code="catalogo.fecha" /></label>
										<div class="input-group date">
											<input type="text" class="form-control campoFecha"  id="fechaDescatalogado"  name="fechaDescatalogado" />
											<div class="input-group-addon calendarioFecha"><span class="glyphicon glyphicon-calendar" aria-hidden="true"></span></div>
										</div>
									</div>
								</div>
								
								<div class="row">
									<div class="col-xs-12 form-group">
										<label><spring:message code="catalogo.tituloCastellano" /></label>
										<input type="text" class="form-control" id="tituloCastellano" name="tituloCastellano" maxlength="100"/>
									</div>
								</div><!-- fin fila -->
								
								<div class="row">
									<div class="col-xs-12 form-group">
										<label><spring:message code="catalogo.tituloEuskera" /></label>
										<input type="text" class="form-control" id="tituloEuskera" name="tituloEuskera"  maxlength="100"/>
									</div>
								</div><!-- fin fila -->
								
								<div class="row">
									<div class="col-sm-6 col-xs-12 form-group">
										<label class="labelGroupRadio"><spring:message code="catalogo.tipo" /></label>
										<label class="radio-inline"><input type="radio" id="monolingueS" name="monolingue" value="S"/><spring:message code="catalogo.monolingue" /></label>
										<label class="radio-inline"><input type="radio" id="monolingueN" name="monolingue" value="N" /><spring:message code="catalogo.multilingue" /></label>
									</div>
	
									<div class="col-sm-6 col-xs-12 form-group">
										<label><spring:message code="catalogo.anoEdicion" /></label>
										<input type="text" class="form-control campoNumerico" id="anioEdicion" name="anioEdicion" maxlength="4" data-v-max="9999" data-a-sep="false" />
										<em><spring:message code="catalogo.notaEdicion" /></em>
									</div>
									
								</div><!-- fin fila -->
								
								<div class="panel panel-default">
									<div class="panel-heading"><label><spring:message code="catalogo.idiomasDisponibles" /></label> <em id="lblAvisoAniadirIdioma" hidden="true">(<spring:message code="ficha.avisoAniadirIdioma" />)</em></div>
									<div class="panel-body">
										<div id="divToolbarTablaIdiomas">
											<button type="button" class="btn btn-light" id="btnAniadirIdioma"><span class="btn-add material-icons">add</span><span><spring:message code="catalogo.botonAnadir" /></span></button>
										</div>
										<div class="row">
											<div class="col-xs-12">										
												<table id="tblIdiomas"></table>
											
											</div>
										</div>
									</div>						
								</div>
								
								<div class="panel panel-default">
									<div class="panel-heading"><label><spring:message code="catalogo.tituloTema" /></label> <em id="lblAvisoAniadirTema" hidden="true">(<spring:message code="ficha.avisoAniadirIdioma" />)</em></div>
									<div class="panel-body">
										<div id="divToolbarTablaTemas">
											<button type="button" class="btn btn-light" id="btnAniadirTema"><span class="btn-add material-icons">add</span><span><spring:message code="catalogo.botonAnadir" /></span></button>
										</div>
										<div class="row">
											<div class="col-xs-12">										
												<table id="tblTemas"></table>
											</div>
										</div>
									</div>
								</div>
								
								<div class="row">
									<div class="col-xs-12 form-group">
										<label><spring:message code="catalogo.formatoDimensiones" /></label>
										<input type="text" class="form-control" id="formato" name="formato"  maxlength="100"/>
									</div>
								</div><!-- fin fila -->								
								
							</div>
						</div>
				</div>
				<div class="modal-footer">
					<button class="btn btn-light notDisabled" type="button"  id="btnCancelarFolleto"><spring:message code="formulario.botonCancelar" /></button>
					<button class="btn btn-green" type="submit" id="btnAceptarFolleto" ><spring:message code="formulario.botonAceptar" /></button>
				</div>
			</div><!-- /.modal-content -->
		</div><!-- /.modal-dialog -->
		<input type="hidden" class="form-control" readonly="readonly" id="codigoTipoMaterial" name="codigoTipoMaterial" />
		<input type="hidden" class="form-control" readonly="readonly" id="codigoMaterial" name="codigoMaterial" />
		<input type="hidden" class="form-control" readonly="readonly" id="filaTablaIdiomas" name="filaTablaIdiomas" />
	</form>
</div><!-- /.modal -->

<div class="modal fade" id="modalIdiomas">
	<form id="formArticuloIdioma" class="form-horizontal">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close notDisabled" id="btnCerrarIdioma" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title"><spring:message code="catalogo.idiomasDisponibles" /></h4>
				</div>
				
				<div class="modal-body">
					<div class="alertPanel" id="divAlertArticuloIdiomasModal"></div>
					<div class="row">
						<div class="col-xs-12 form-group">
							<label class="checkbox-inline"><input type="checkbox" id="descatalogadoA"  name="descatalogado" value="S"><spring:message code="catalogo.descatalogado" /></label>
						</div>
					</div><!-- fin fila -->
					
					<div class="panel panel-default ocultar" id="divMantIdiomasMulti">
						<div class="panel-heading"><label><spring:message code="catalogo.listaIdiomas" /></label></div>
						<div class="panel-body">
							<div id="divToolbarIdiomasMulti" class="row">
								<div class="col-xs-12 form-group">
									<div class="input-group">
	<%-- 									<label><spring:message code="catalogo.idioma" /></label> --%>
										<form:select class="form-control" path="idioma" id="cboIdiomaMulti" name="cboIdiomaMulti">
											<form:option value="" label="" />
											<form:options items="${idiomas}" />
										</form:select>
										<span class="input-group-btn">
											<button type="button" class="btn btn-light" id="btnAniadirIdiomaMulti"><span class="btn-add material-icons">add</span><span><spring:message code="catalogo.botonAnadir" /></span></button>
										</span>
									</div>
								</div>
							</div>
							<div class="row">
								<div class="col-xs-12">										
									<table id="tblIdiomasMulti" data-toolbar="#divToolbarIdiomasMulti" data-toolbar-align="right"></table>
								</div>
							</div>
						</div>
					</div>
					
					<div class="row">
						<div class="col-sm-6 col-xs-12 form-group" id="divIdiomaMonolingue">
							<label><spring:message code="catalogo.idioma" /></label>
							<form:select class="form-control" path="idioma" id="idiomaMono" name="idioma">
								<form:option value="" label="" />
								<form:options items="${idiomas}" />
							</form:select>
						</div>
						
						<div class="col-sm-6 col-xs-12 form-group">
							<label><spring:message code="catalogo.codigoAlmacen" /></label>
							<input type="text" class="form-control" id="codigoAlmacen"  name="codigoAlmacen" maxlength="10"/>
						</div>
					</div><!-- fin fila -->
					
					<div class="row">								
						<div class="col-sm-6 col-xs-12 form-group">
							<label><spring:message code="catalogo.stock" /></label>
							<input type="text" class="form-control campoNumerico" id="stock"  name="stock" data-v-max="999999" maxlength="6" />
						</div>
						
						<div class="col-sm-6 col-xs-12 form-group">
							<label><spring:message code="catalogo.minimo" /></label>
							<input type="text" class="form-control campoNumerico" id="stockMin"  name="stockMin" data-v-max="999999" maxlength="6" />
						</div>
					</div><!-- fin fila -->
					
					
					<div class="row">
						<div class="col-xs-12 form-group">
							<label><spring:message code="catalogo.portada" /></label>
							<div class="input-group">
								<input type="text" class="form-control" id="urlPortada"  name="urlPortada" maxlength="256"/>
								<span class="input-group-btn">
									<button class="btn btn-light notDisabled"  type="button" id="btnCheckUrlPortada"><spring:message code="accion.test" /></button>
								</span>
								
							</div>
						</div>
					</div><!-- fin fila -->
					
					<div class="row">
						<div class="col-xs-12 form-group">
							<label><spring:message code="catalogo.pdfMaterial" /></label>
							<div class="input-group">
 								<input type="text" class="form-control" id="urlPDF"  name="urlPDF"  maxlength="256"/>
								<span class="input-group-btn">
									<button class="btn btn-light notDisabled"  type="button" id="btnCheckUrlPDF"><spring:message code="accion.test" /></button>
								</span>
							</div>
						</div>
					</div><!-- fin fila -->
					
					<div class="panel panel-default">
						<div class="panel-heading"><label><spring:message code="catalogo.datosNecesarios" /></label></div>
						<div class="panel-body">
							<div class="row">
								<div class="col-xs-12 form-group">
									<label class="radio-inline"><input type="radio" id="modoPeticionE" name="modoPeticion" value="E" /><spring:message code="catalogo.solicitudEjemplar" /></label>
									<label class="radio-inline"><input type="radio" id="modoPeticionC" name="modoPeticion" value="C" /><spring:message code="catalogo.solicitudCajas" /></label>
								</div>
							</div><!-- fin fila -->
							
							<div class="panel panel-default" id="divEjemplares">
								<div class="panel-heading"><label><spring:message code="catalogo.ejemplar" /></label></div>
								<div class="panel-body">
									<div class="row">
										<div class="col-sm-6 col-xs-12 form-group">
											<label><spring:message code="catalogo.minimoEjemplares" /></label>
											<input type="text" class="form-control campoNumerico" id="numMinimoE" name="numMinimo" data-v-max="999999" maxlength="6"/> 
										</div>
										<div class="col-sm-6 col-xs-12 form-group">
											<label><spring:message code="catalogo.formaEnvio" /></label>
													<form:select class="form-control" path="formaEnvio" id="codigoFormaEnvioE" name="codigoFormaEnvio">
														<form:option value="" label="" />
														<form:options items="${formasEnvio}" />
													</form:select>
										</div>
									</div><!-- fin fila -->
								</div>
							</div>
							
							<div class="panel panel-default ocultar" id="divCajas">
								<div class="panel-heading"><label><spring:message code="catalogo.cajas" /></label></div>
								<div class="panel-body">
									<div class="row">
										<div class="col-sm-6 col-xs-12 form-group">
											<label><spring:message code="catalogo.ejemplaresCaja" /></label>
											<input type="text" class="form-control campoNumerico" id="numEjemplares" name="numEjemplares" data-v-max="999999" maxlength="6" />
										</div>
										<div class="col-sm-6 col-xs-12 form-group">
											<label><spring:message code="catalogo.minimoCajas" /></label>
											<input type="text" class="form-control campoNumerico" id="numMinimoC" name="numMinimo" data-v-max="999999" maxlength="6"/>
										</div>
									</div>
									<div class="row">
										<div class="col-sm-6 col-xs-12 form-group">
											<label><spring:message code="catalogo.formaEnvio" /></label>
											<form:select class="form-control" path="formaEnvio" id="codigoFormaEnvioC" name="codigoFormaEnvio">
												<form:option value="" label="" />
												<form:options items="${formasEnvio}" />
											</form:select>
										</div>
									</div><!-- fin fila -->
								</div>
							</div>
							
						</div>
					</div>
				</div>
				<div class="modal-footer">
					<button class="btn btn-light notDisabled"  type="button" id="btnCancelarIdioma"><spring:message code="formulario.botonCancelar" /></button>
					<button class="btn btn-green" type="submit" id="btnAceptarIdioma"><spring:message code="formulario.botonAceptar" /></button>
				</div>
			</div><!-- /.modal-content -->
		</div><!-- /.modal-dialog -->
			<input type="hidden" class="form-control" readonly="readonly" id="codArticulo" name="codArticulo" />
			<input type="hidden" class="form-control" readonly="readonly" id="codMaterial" name="codMaterial" />
	</form>
</div><!-- /.modal -->

<div class="modal fade" id="modalTema">
	<form class="form-horizontal" id="frmTema">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close notDisabled" id="btnCerrarTema" aria-label="Close"><span aria-hidden="true">&times;</span></button>
					<h4 class="modal-title"><spring:message code="catalogo.anadirTema" /></h4>
				</div>
				<div class="modal-body">
					<div class="alertPanel" id="divAlertTemaModal"></div>
													
						<div class="row">
							<div class="col-xs-12 form-group">
								<label><spring:message code="catalogo.tema" /></label>
								<select class="form-control" id="cboTema" name="codigoTemaMaterial">
								<option>&nbsp;</option>
							</select>
							</div>
						</div><!-- fin fila -->
						
						<div class="row">
							<div class="col-xs-12 form-group">
								<label class="checkbox-inline"><input type="checkbox" value="true" id="chkPrincipal" name="principal"/><spring:message code="catalogo.temaPrincipal" /></label>
							</div>
						</div><!-- fin fila -->
					<input type="hidden" class="form-control" readonly="readonly" id="codMaterialTema" name="codigoMaterial" />
				</div>
				<div class="modal-footer">
					<button class="btn btn-light" type="button" id="btnCancelarTema"><spring:message code="formulario.botonCancelar" /></button>
					<button class="btn btn-green" type="submit" id="btnAceptarTema"><spring:message code="formulario.botonAceptar" /></button>
				</div>
			</div><!-- /.modal-content -->
		</div><!-- /.modal-dialog -->
	</form>
</div><!-- /.modal -->
