<%@include file="/WEB-INF/includeTemplate.inc"%>
<div class="container ng-scope">
	<header>
		<h2><spring:message code="app.folletos" /></h2>
	</header>
	<section>
		<header>
			<h3><spring:message code="menu.catalogoGeneral" /></h3>
		</header>
		<div class="alertPanel" id="divAlert"></div>
		<div class="panel panel-default">
			<div class="panel-heading tooglePanel" role="button" data-toggle="collapse" href="#divCriteriosBusqueda" aria-expanded="true" aria-controls="divCriteriosBusqueda">
				<a href="#">
					<spring:message code="buscador.criteriosBusqueda" />
				</a>
				<a href="#" class="pull-right">
					<i class="icon material-icons">keyboard_arrow_up</i>
				</a>
		  </div>
		  <div class="panel-body panel-collapse collapse in" id="divCriteriosBusqueda" aria-expanded="true">
			<form class="form-horizontal" id="frmBusqueda">
				<div class="row">
					<div class="col-sm-6 col-xs-12 form-group ">
						<label><spring:message code="buscador.texto" /></label>
						<input type="text" class="form-control" id="texto" name="texto" />
					</div>
					<div class="col-sm-6 col-xs-12 form-group">
						<label><spring:message code="buscador.tipoMaterial" /></label>
						<form:select class="form-control" path="tipoMaterial" id="tipoMaterial" name="tipoMaterial">
							<form:option value="" label="" />
							<form:options items="${tiposMaterial}" />
						</form:select>
					</div>
				</div>
				<div class="row">
					<div class="col-sm-6 col-xs-12 form-group ">
						<label><spring:message code="buscador.tema" /></label>
						<select class="form-control" id="tema" name="tema">
							<option>&nbsp;</option>
						</select>
					</div>
					<div class="col-sm-6 col-xs-12 form-group ">
						<label><spring:message code="buscador.idioma" /></label>
						<form:select class="form-control" path="idioma" name="idioma">
							<form:option value="" label="" />
							<form:options items="${idiomas}" />
						</form:select>
					</div>
				</div>
				<div class="row">
					<div class="col-xs-12 form-group">
						<button class="btn btn-light" type="button" id="btnLimpiar"><spring:message code="buscador.botonLimpiar" /></button>
						<button class="btn btn-green" type="button" id="btnBuscar"><spring:message code="buscador.botonBuscar" /></button>
					</div>
				</div>				
			</form>
		  </div>
		</div>

		<div id="divToolbarTabla">
<%-- 			<button type="button" class="btn btn-light" id="btnNuevo"><span class="btn-add material-icons">add</span><span><spring:message code="catalogo.botonAnadir" /></span></button> --%>
			
			<div class="btn-group dropup">
			  <button type="button" class="btn btn-light dropdown-toggle" data-toggle="dropdown" id="btnNuevo"><span class="btn-add material-icons">add</span><span><spring:message code="catalogo.botonAnadir" /></span></button>			  
			  <ul class="dropdown-menu">
			    <li>
			    	<a href="javascript:void(0)" id="btnNuevoFolleto">
						<i class="icon material-icons">library_add</i><span><spring:message code="accion.folleto" /></span>
					</a>
			    </li>
			    <li>
			    	<a href="javascript:void(0)" id="btnNuevoMaterialPromocional">
						<i class="icon material-icons">library_add</i><span><spring:message code="accion.materialPromocional" /></span>
					</a>
			    </li>
			  </ul>
			</div>
			
		</div>

		<div class="row">
			<div class="col-xs-12">
				<table id="tblBusqueda"></table>
			</div>
		</div>
	</section>
</div>

<%@include file="/WEB-INF/views/fichaFolleto.inc" %>
<%@include file="/WEB-INF/views/fichaMaterialPromocional.inc" %>
