package com.ejie.u74a.util;

import org.springframework.security.core.context.SecurityContextHolder;

import com.ejie.u74a.model.UsuarioDetalles;

/**
 * Clase con métodos de utilidad común.
 * 
 *  
 * 
 */
public class Utilidades {

	/**
	 * Constructor privado. Clase de Utilidades.
	 */
	private Utilidades() {
	}

	/**
	 * Obtiene la consulta incluyendo la paginación.
	 * 
	 * @param query La consulta a la que añadir la paginación.
	 * @param numRegistro El número de registro del primer registro a devolver.
	 * @param numRegistrosPagina El número de registros por página.
	 * @param columnaOrden Columna por la que se ordena, opcional.
	 * @param orden El tipo de orden si se ha informado columna por la que ordenar, asc: ascendiente, desc:
	 *            descendiente.
	 * @return StringBuilder Devuelve la consulta que incluye la paginación.
	 */
	public static StringBuilder getPaginationQuery(StringBuilder query, Integer numRegistro,
			Integer numRegistrosPagina, String columnaOrden, String orden) {
		StringBuilder paginationQuery = new StringBuilder();
		if (columnaOrden != null) {
			paginationQuery.append(" ORDER BY ");
			paginationQuery.append(columnaOrden);
			paginationQuery.append(" ");
			paginationQuery.append(orden);
			query.append(paginationQuery);
		}
		paginationQuery = new StringBuilder();

		if (numRegistrosPagina != null && numRegistro != null) {
			paginationQuery
					.append("SELECT b.* FROM (SELECT rownum rnum, a.*  FROM (" + query + ")a) b where rnum between ")
					.append((numRegistro + 1)).append(" and ").append((numRegistro + numRegistrosPagina));
		}/*
		 * else if (numRegistro != null) { TODO Revisar si este caso va a hacer falta
		 * paginationQuery.append("SELECT b.* FROM (SELECT rownum rnum, a.*  FROM (" + query).append(
		 * ")a) b where rnum > 0 and rnum < " + (numRegistro + 1)); }
		 */else {
			return query;
		}
		return paginationQuery;
	}

	/**
	 * Obtiene los datos del usuario autenticado del contexto.
	 * 
	 * @return datos del usuario autenticado
	 */
	public static UsuarioDetalles getDetallesUsuario() {
		UsuarioDetalles usuarioDetalles = null;
		Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();

		if (principal instanceof UsuarioDetalles) {
			usuarioDetalles = (UsuarioDetalles) principal;
		}

		return usuarioDetalles;
	}

}