/*
 * Copyright 2011 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 * http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito,
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */
package com.ejie.u74a.util;

import java.text.SimpleDateFormat;

/**
 * 
 *  
 * 
 */
public class Constants {

	/**
	 * Constructor privado. Clase de constantes.
	 */
	private Constants() {
	}

	public static final String EUSKARA = "eu";
	public static final String FRANCAIS = "fr";
	public static final String CASTELLANO = "es";
	public static final String ENGLISH = "en";

	public static final SimpleDateFormat DDMMYYYY_DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy");
	public static final SimpleDateFormat YYYYMMDD_DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");

	public static final SimpleDateFormat DDMMYYYY_HHMMSS_DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
	public static final SimpleDateFormat YYYYMMDD_HHMMSS_DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

	public static final SimpleDateFormat HHMMSS_TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");

	// SOLICITUDES
	public static final String ESTADO_PENDIENTE = "P";
	public static final String ESTADO_ACEPTADA = "A";
	public static final String ESTADO_RECHAZADA = "R";

	// MATERIALES
	public static final int TIPO_MATERIAL_FOLLETO = 1;
	public static final int TIPO_MATERIAL_PROMOCIONAL = 5;

	public static final String TIPO_IDIOMA_MONOLINGUE = "S";
	public static final String TIPO_IDIOMA_MULTI_O_SIN_IDIOMA = "N";

	public static final String DESCATALOGADO = "S";
	public static final String NO_DESCATALOGADO = "N";

	public static final String TIPO_ES_ENTRADA = "E";
	public static final String TIPO_ES_SALIDA = "S";

	public static final String SUBTIPO_ES_CORRECCION_STOCK = "10";
	public static final String SUBTIPO_ES_PETICION = "21";

	public static final String CODIGO_OFICINA_GV = "1C028";

	public static final String MODO_ENVIO_EJEMPLARES = "E";
	public static final String MODO_ENVIO_CAJAS = "C";

	// Manuales
	public static final String MANUAL_USUARIO = "Manual_Peticion_Folletos.pdf";
	public static final String MANUAL_GESTOR = "Manual_Gestion_Folletos.pdf";

	public static final String MULTILINGUE = "M";
	public static final String SIN_IDIOMA = "S";

	public static final int REGISTRO_ACTIVO = 0;
	public static final int REGISTRO_BORRADO = 1;

}