package com.ejie.u74a.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.u74a.dao.UsuarioDao;
import com.ejie.u74a.model.Usuario;

/**
 * Clase que implementa los servicios de acceso a los datos del usuario
 * 
 *  
 */
@Service(value = "usuarioService")
@Transactional()
public class UsuarioServiceImpl implements UsuarioService {

	@Autowired()
	private UsuarioDao dao;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.UsuarioService#findByCodigoUsuario(int)
	 */
	@Override()
	public Usuario findByCodigoUsuario(int codigoUsuario) {
		return this.dao.findByCodigoUsuario(codigoUsuario);
	}

}
