package com.ejie.u74a.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.u74a.dao.UbicacionDao;
import com.ejie.u74a.model.Ubicacion;
import com.ejie.u74a.util.Utilidades;

/**
 * Clase que implementa los servicios de acceso a los datos de ubicaciones.
 * 
 *  
 */
@Service(value = "ubicacionService")
@Transactional()
public class UbicacionServiceImpl implements UbicacionService {

	@Autowired()
	private UbicacionDao dao;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.UbicacionService#findByCodigo(int)
	 */
	@Override()
	public Ubicacion findByCodigo(int codigoUbicacion) {
		return this.dao.findByCodigo(codigoUbicacion);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.UbicacionService#findByCodigoOficina(java.lang.String)
	 */
	@Override()
	public List<Ubicacion> findByCodigoOficina(String codigoOficina) {
		return this.dao.findByCodigoOficina(codigoOficina);
	}

	// @Override()
	// public List<Ubicacion> findByCodigoOficinaActivos(String codigoOficina) {
	// return this.dao.findByCodigoOficinaActivos(codigoOficina);
	// }

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.UbicacionService#saveUbicacion(com.ejie.u74a.model.Ubicacion)
	 */
	@Transactional()
	@Override()
	public int saveUbicacion(Ubicacion ubicacion) {
		if (ubicacion.getCodigoUbicacion() != null) {
			return this.dao.updateUbicacion(ubicacion);
		} else {

			ubicacion.setCodigoOficina(Utilidades.getDetallesUsuario().getCodigoOficina());
			return this.dao.insertUbicacion(ubicacion);
		}
	}

	@Transactional()
	@Override()
	public int deleteUbicacion(Integer codUbicacion) {
		// comprobamos si la ubicación está relacionada con alguna petición
		if (this.dao.findExisteUbicacionPeticion(codUbicacion)) {
			// si existe relación, hacemos baja lógica
			return this.dao.deleteLogicaUbicacion(codUbicacion);
		} else {
			// si no existe relación, hacemos baja física
			return this.dao.deleteFisicaUbicacion(codUbicacion);
		}
	}

}
