package com.ejie.u74a.service;

import java.util.List;

import com.ejie.u74a.model.Ubicacion;

/**
 * Interfaz de los servicios de acceso a los datos de ubicaciones.
 * 
 *  
 */
public interface UbicacionService {

	/**
	 * Obtiene los datos de la ubicación dado su código.
	 * 
	 * @param codigoUbicacion el código de la ubicación.
	 * 
	 * @return Los datos de la ubicación que corresponde al código proporcionado.
	 */
	Ubicacion findByCodigo(int codigoUbicacion);

	/**
	 * Obtiene el listado de puntos de recepción de una oficina
	 * 
	 * @param codigoOficina código de la oficina
	 * @return listado de puntos de recepción
	 */
	List<Ubicacion> findByCodigoOficina(String codigoOficina);

	/**
	 * Guarda los datos de un puto de recepción
	 * 
	 * @param ubicacion datos del punto de recepción
	 * @return número de filas afectadas
	 */
	int saveUbicacion(Ubicacion ubicacion);

	/**
	 * Comprueba si una ubicación está relacionada con una petición
	 * 
	 * @param codUbicacion código de la ubicación
	 * @return true en caso de exister relación. False en caso de no existir relación
	 */
	int deleteUbicacion(Integer codUbicacion);

	/**
	 * Obtiene la lista de las ubicaciones asociadas a una oficina. (solo las activas)
	 * 
	 * @param codigoOficina el código de la oficina.
	 * 
	 * @return Lista de las ubicaciones asociadas a una oficina.
	 */
	// List<Ubicacion> findByCodigoOficinaActivos(String codigoOficina);

}