package com.ejie.u74a.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.u74a.dao.TemaMaterialDao;
import com.ejie.u74a.model.TemaMaterial;

/**
 * Clase que implementa los servicios de acceso a los datos de temas asociados a
 * un tipo de material.
 * 
 *  
 */
@Service(value = "temaMaterialService")
@Transactional()
public class TemaMaterialServiceImpl implements TemaMaterialService {

	@Autowired()
	private TemaMaterialDao dao;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.TemaMaterialService#findByTipoMaterial(int)
	 */
	@Override()
	public List<TemaMaterial> findByTipoMaterial(int codigoTipoMaterial) {
		return this.dao.findByTipoMaterial(codigoTipoMaterial);
	}

}
