package com.ejie.u74a.service;

import java.util.List;

import com.ejie.u74a.model.FichaSolicitud;

/**
 * Interfaz de los servicios de acceso a los datos de materiales.
 * 
 *  
 */
public interface SolicitudService {

	/**
	 * Obtiene una lista de artículos asociados a los materiales seleccionados, la oficina de origen, la lista de
	 * posibles puntos de recogida.
	 * 
	 * 
	 * @param codigosArticulosLst Lista de los articulos seleccionados para la solicitud.
	 * 
	 * @return objeto @link{FichaSolicitud} con los datos a rellenar para la solicitud.
	 */
	FichaSolicitud detalleSolicitud(List<Integer> codigosArticulosLst); // codigosMaterialesLst

	/**
	 * Guarda la lista de articulos solicitados.
	 * 
	 * @param fichaSolicitud {@link FichaSolicitud} Objeto con los datos de la solicitud
	 * 
	 * @return String mensaje con el erro si ha fallado al guardar la solicitud, blanco en caso contrario.
	 */
	String guardarSolicitud(FichaSolicitud fichaSolicitud);

}