package com.ejie.u74a.service;

import java.util.List;

import com.ejie.u74a.model.CriteriosBusqueda;
import com.ejie.u74a.model.Peticion;
import com.ejie.u74a.model.UbicacionInforme;

/**
 * Interfaz de los servicios de acceso a los datos de peticiones.
 * 
 *  
 */
public interface PeticionService {

	/**
	 * Obtiene las peticiones dependiendo del filtro aplicado.
	 * 
	 * @param filtro Clase con los filtros de búsqueda.
	 * 
	 * @return lista con las peticiones
	 */
	List<Peticion> findByCriteria(CriteriosBusqueda filtro);

	/**
	 * Obtiene el número de las peticiones que cumplen del filtro aplicado.
	 * 
	 * @param filtro Clase con los filtros de búsqueda.
	 * 
	 * @return int número de las peticiones que cumplen el filtro aplicado.
	 */
	int findByCountCriteria(CriteriosBusqueda filtro);

	/**
	 * Cambia el estado a una lista de peticiones.
	 * 
	 * @param lstPeticiones La lista con los objetos Peticion.
	 * @return String con resultado Ok si ha ido bien.
	 */
	String cambiarEstadoPeticion(List<Peticion> lstPeticiones);

	/**
	 * Genera un informe para enviar a almacén con un conjunto de peticiones aceptadas.
	 * 
	 * @param codigosPeticionLst La lista con los códigos de petición.
	 * 
	 * @return Objeto con toda la información necesaria para la generación del informe
	 */
	List<UbicacionInforme> generarInforme(List<Integer> codigosPeticionLst);

	/**
	 * Obtiene la lista de solicitudes realizadas por el usuario conectado
	 * 
	 * @param filtro Clase con los filtros de búsqueda.
	 * @return lista de solicitudes
	 */
	List<Peticion> findByCriteriaMisSolicitudes(CriteriosBusqueda filtro);

	/**
	 * devuelve el número de solicitudes obtenidas en la consulta
	 * 
	 * @param filtro Clase con los filtros de búsqueda.
	 * @return número de solicitudes
	 */
	int findByCountCriteriaMisSolicitudes(CriteriosBusqueda filtro);

	/**
	 * devuelve los datos completos de una petición, incluyendo los datos de la ubicación
	 * 
	 * @param codigoPeticion código de la petición a obtener
	 * @return detalle de la petición
	 */
	Peticion findDetalleByCodigo(int codigoPeticion);

}