package com.ejie.u74a.service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.u74a.dao.ArticuloDao;
import com.ejie.u74a.dao.IdiomaDao;
import com.ejie.u74a.dao.MaterialDao;
import com.ejie.u74a.model.Articulo;
import com.ejie.u74a.model.CriteriosBusqueda;
import com.ejie.u74a.model.Idioma;
import com.ejie.u74a.model.Material;
import com.ejie.u74a.model.TemaMaterial;
import com.ejie.u74a.model.UsuarioDetalles;
import com.ejie.u74a.util.Constants;
import com.ejie.u74a.util.Utilidades;

/**
 * Clase que implementa los servicios de acceso a los datos de materiales.
 * 
 *  
 */
@Service(value = "materialService")
@Transactional()
public class MaterialServiceImpl implements MaterialService {

	@Autowired()
	private MaterialDao dao;

	@Autowired()
	private IdiomaDao idiomaDao;

	@Autowired()
	private ArticuloDao articuloDao;

	// @Resource(name = "appMessageSource")
	// private ReloadableResourceBundleMessageSource messageSource;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.MaterialService#findByCriteria(CriteriosBusqueda)
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<Material> findByCriteria(CriteriosBusqueda filtro) {
		List<Material> materiales = this.dao.findByCriteria(filtro);

		// Recuperar la descripción del idioma para no mostrar la lista de
		// claves.
		List<Idioma> idiomas = this.idiomaDao.findAll();
		HashMap<String, String> idiomaHsh = new HashMap<String, String>();
		for (Idioma idioma : idiomas) {
			idiomaHsh.put(idioma.getCodigo(), idioma.getNombre(LocaleContextHolder.getLocale()));
		}
		return materiales;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.MaterialService#findByCountCriteria(CriteriosBusqueda )
	 */
	@Transactional(readOnly = true)
	@Override()
	public int findByCountCriteria(CriteriosBusqueda filtro) {
		return this.dao.findByCountCriteria(filtro);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.MaterialService#getDetalleMaterial(int, boolean, boolean)
	 */
	@Transactional(readOnly = true)
	@Override()
	public Material getDetalleMaterial(int codigoMaterial, boolean incluirTemasSecundarios, boolean incluirInfoArticulo) {
		return this.dao.findByCodigo(codigoMaterial, incluirTemasSecundarios, incluirInfoArticulo);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.MaterialService#getDetainsertTemaMateriallleMaterial (int, int, boolean)
	 */
	@Transactional()
	@Override()
	public TemaMaterial insertTemaMaterial(TemaMaterial temaMaterial) {

		if (temaMaterial.isPrincipal()) {
			this.dao.updateTemaMaterial(temaMaterial);

		} else {
			this.dao.insertTemaMaterial(temaMaterial);

		}
		return temaMaterial;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.MaterialService#borrarTemaMaterial(int, int, boolean)
	 */
	@Transactional()
	@Override()
	public TemaMaterial borrarTemaMaterial(TemaMaterial temaMaterial) {

		if (temaMaterial.isPrincipal()) {
			this.dao.deleteTemaMaterialPpal(temaMaterial.getCodigoMaterial()); // Null para borrar tema principal

		} else {
			this.dao.deleteTemaMaterial(temaMaterial);

		}
		return temaMaterial;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.MaterialService#actualizarMaterial(Material)
	 */
	@Transactional()
	@Override()
	public Material actualizarMaterial(Material material) {
		UsuarioDetalles usuario = Utilidades.getDetallesUsuario();
		Date hoy = new Date();
		material.setCodigoUsuarioModificacion(Integer.parseInt(usuario.getUsername()));
		material.setFechaModificacion(hoy);

		if (material.getCodigoTipoMaterial() == Constants.TIPO_MATERIAL_FOLLETO) {
			material = this.dao.actualizarMaterial(material);

			if (Constants.DESCATALOGADO.equals(material.getDescatalogado())) {
				// Actualizar sus articulos a descatalogados
				this.dao.actualizarDescatalogadoArticulosMaterial(Constants.DESCATALOGADO, material.getCodigoMaterial());
			}

		} else {
			// En los materiales promocionales no hay idioma.
			material.setMonolingue(Constants.TIPO_IDIOMA_MULTI_O_SIN_IDIOMA);
			material = this.dao.actualizarMaterial(material);
			Articulo articulo = material.getArticuloPromocional();
			if (articulo != null) {
				articulo.setCodigoUsuarioModificador(Integer.parseInt(usuario.getUsername()));
				articulo.setFechaModificacion(hoy);

				// TODO si no llega descatalogado es porque no se ha enviado el check y es N, mandarlo siempre?
				// El articulo de material promocional debe tener el mismo
				// valor para descatalogado que el
				// material
				if (Constants.DESCATALOGADO.equals(material.getDescatalogado())) {
					// Si el material está descatalogado, el artículo también.
					articulo.setDescatalogado(Constants.DESCATALOGADO);
				} else if (material.getDescatalogado() == null
						|| Constants.NO_DESCATALOGADO.equals(material.getDescatalogado())) {
					articulo.setDescatalogado(Constants.NO_DESCATALOGADO);
				}
				if (articulo.getCodArticulo() == null) {
					articulo.setCodMaterial(material.getCodigoMaterial());
					articulo = this.articuloDao.insertarArticulo(articulo);

				} else {
					articulo = this.articuloDao.actualizarArticulo(articulo);
				}
			}

		}
		// }
		return material;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.MaterialService#insertarMaterial(Material)
	 */
	@Transactional()
	@Override()
	public Material insertarMaterial(Material material) {
		UsuarioDetalles usuario = Utilidades.getDetallesUsuario();
		Date hoy = new Date();
		material.setCodigoUsuarioModificacion(Integer.parseInt(usuario.getUsername()));
		material.setFechaModificacion(hoy);

		if (material.getCodigoTipoMaterial() == Constants.TIPO_MATERIAL_FOLLETO) {
			material = this.dao.insertarMaterial(material);

		} else {
			// En los materiales promocionales no hay idioma.
			material.setMonolingue(Constants.TIPO_IDIOMA_MULTI_O_SIN_IDIOMA);
			material = this.dao.insertarMaterial(material);
			Articulo articulo = material.getArticuloPromocional();
			if (articulo != null) {
				articulo.setCodMaterial(material.getCodigoMaterial());
				articulo.setCodigoUsuarioModificador(Integer.parseInt(usuario.getUsername()));
				articulo.setFechaModificacion(hoy);

				articulo.setDescatalogado(material.getDescatalogado());

				articulo = this.articuloDao.insertarArticulo(articulo);
			}

		}
		return material;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.MaterialService#cambioTipoIdiomaDeMaterial(int)
	 */
	@Transactional()
	@Override()
	public String cambioTipoIdiomaDeMaterial(int codigoMaterial, String pMonolingue) {
		this.articuloDao.borrarArticulosDeMaterial(codigoMaterial);
		String monolingue = pMonolingue;
		if (!Constants.TIPO_IDIOMA_MONOLINGUE.equals(monolingue)) {
			monolingue = Constants.TIPO_IDIOMA_MULTI_O_SIN_IDIOMA;
		}
		this.dao.updateTipoIdiomaMaterial(codigoMaterial, monolingue);

		return "{\"resultado\": \"OK\"}";
	}
}
