package com.ejie.u74a.service;

import java.util.Properties;

import javax.annotation.Resource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

/**
 * Clase que implementa los servicios de envío de correo.
 * 
 *  
 */
@Service(value = "mailService")
public class MailServiceImpl implements MailService {

	/** The simple mail message. */
	@Autowired()
	private SimpleMailMessage simpleMailMessage;

	/** The mail sender. */
	@Autowired()
	private JavaMailSender mailSender;

	@Resource(name = "appConfiguration")
	private Properties config;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.MailService#sendMail(java.lang.String, java.lang.String)
	 */
	@Override()
	public void sendMail(String to, String body) {
		this.simpleMailMessage.setTo(to);
		this.simpleMailMessage.setText(body);
		this.mailSender.send(this.simpleMailMessage);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.MailService#sendMail(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override()
	public void sendMail(String to, String subject, String body) {
		this.simpleMailMessage.setTo(to);
		this.simpleMailMessage.setSubject(subject);
		this.simpleMailMessage.setText(body);
		this.mailSender.send(this.simpleMailMessage);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.MailService#sendRichMail(java.lang.String, java.lang.String, java.lang.String)
	 */
	@Override()
	public void sendRichMail(String to, String subject, String body) throws MessagingException {
		MimeMessage message = this.mailSender.createMimeMessage();
		MimeMessageHelper helper = new MimeMessageHelper(message, true);
		helper.setFrom(this.config.getProperty("email.from"));
		helper.setTo(to);
		helper.setSubject(subject);
		helper.setText(body, true);
		this.mailSender.send(message);
	}

}
