package com.ejie.u74a.service;

import javax.mail.MessagingException;

/**
 * Interfaz del servicio de envío de correo.
 * 
 *  
 */
public interface MailService {

	/**
	 * Envía un correo con el asunto por defecto.
	 * 
	 * @param to Destinatario
	 * @param body Mensaje
	 */
	public void sendMail(String to, String body);

	/**
	 * Envía un correo con los datos especificados.
	 * 
	 * @param to Destinatario
	 * @param subject Asunto
	 * @param body Mensaje
	 */
	public void sendMail(String to, String subject, String body);

	/**
	 * Envía un correo con soporte para HTML con los datos especificados.
	 * 
	 * @param to Destinatario
	 * @param subject Asunto
	 * @param body Mensaje
	 * 
	 * @throws MessagingException Messaging exception
	 */
	public void sendRichMail(String to, String subject, String body) throws MessagingException;

}