package com.ejie.u74a.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.u74a.dao.ArticuloDao;
import com.ejie.u74a.dao.RegistroEntradasSalidasDao;
import com.ejie.u74a.model.Articulo;
import com.ejie.u74a.model.CriteriosBusqueda;
import com.ejie.u74a.model.RegistroES;

/**
 * Clase que implementa los servicios de acceso a los datos para la gestion de stock.
 * 
 *  
 */
@Service(value = "gestionStockService")
@Transactional()
public class GestionStockServiceImpl implements GestionStockService {

	@Autowired()
	private ArticuloDao dao;

	@Autowired()
	private RegistroEntradasSalidasDao registroESdao;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.GestionStockService#findByCriteria(CriteriosBusqueda)
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<Articulo> findByCriteria(CriteriosBusqueda filtro) {
		List<Articulo> articulosLst = this.dao.findByCriteriaGestionStock(filtro);

		return articulosLst;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.GestionStockService#findByCountCriteria(CriteriosBusqueda)
	 */
	@Transactional(readOnly = true)
	@Override()
	public int findByCountCriteria(CriteriosBusqueda filtro) {
		return this.dao.findByCountCriteriaGestionStock(filtro);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.GestionStockService#findByCriteria(CriteriosBusqueda)
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<RegistroES> findRegistrosESByCodigo(CriteriosBusqueda filtro) {
		return this.registroESdao.findByCodigo(filtro);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.GestionStockService#findByCountCriteria(CriteriosBusqueda)
	 */
	@Transactional(readOnly = true)
	@Override()
	public int findRegistrosESByCodigoCount(CriteriosBusqueda filtro) {
		return this.registroESdao.findByCodigoCount(filtro);
	}
}
