package com.ejie.u74a.service;

import java.util.List;

import com.ejie.u74a.model.Articulo;
import com.ejie.u74a.model.CriteriosBusqueda;
import com.ejie.u74a.model.RegistroES;

/**
 * Interfaz de los servicios de acceso a los datos para la gestion de stocks
 * 
 *  
 */
public interface GestionStockService {

	/**
	 * Obtiene los artículos dependiendo del filtro aplicado.
	 * 
	 * @param filtro Clase con los filtros de búsqueda.
	 * 
	 * @return lista con los artículos.
	 */
	List<Articulo> findByCriteria(CriteriosBusqueda filtro);

	/**
	 * Obtiene el número de los artículos que cumplen del filtro aplicado.
	 * 
	 * @param filtro Clase con los filtros de búsqueda.
	 * 
	 * @return int número de los artículos que cumplen el filtro aplicado.
	 */
	int findByCountCriteria(CriteriosBusqueda filtro);

	/**
	 * Obtiene la lista paginada de entradas y salidas para un código de artículo.
	 * 
	 * @param filtro {@link CriteriosBusqueda} objeto con el filtro a cumplir (codigoArticulo).
	 * @return Devuelve la lista paginada de entradas y salidas para un código de artículo.
	 */
	List<RegistroES> findRegistrosESByCodigo(CriteriosBusqueda filtro);

	/**
	 * Devuelve el número de entradas y salidas que tiene un código de artículo.
	 * 
	 * @param filtro {@link CriteriosBusqueda} objeto con el filtro a cumplir (codigoArticulo).
	 * @return Devuelve el número de filas afectadas.
	 */
	int findRegistrosESByCodigoCount(CriteriosBusqueda filtro);

}