package com.ejie.u74a.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.u74a.dao.ComboDao;
import com.ejie.u74a.model.Combo;

/**
 * Clase que implementa los servicios de acceso para la carga de combos
 * 
 *  
 */
@Service(value = "comboService")
@Transactional()
public class ComboServiceImpl implements ComboService {

	@Autowired()
	private ComboDao dao;

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.ComboService#findMunicipiosByProvincia(int)
	 */
	@Override()
	public List<Combo> findMunicipiosByProvincia(int codProvincia) {
		return this.dao.findMunicipiosByProvincia(codProvincia);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.ComboService#findLocalidadesByMunicipio(int, int)
	 */
	@Override()
	public List<Combo> findLocalidadesByMunicipio(int codProvincia, int codMunicipio) {
		return this.dao.findLocalidadesByMunicipio(codProvincia, codMunicipio);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.service.ComboService#findProvincias()
	 */
	@Override()
	public List<Combo> findProvincias() {
		return this.dao.findProvincias();
	}

}
