package com.ejie.u74a.service;

import java.util.List;

import com.ejie.u74a.model.Combo;

/**
 * Interfaz de los servicios de acceso a la carga de combos
 * 
 *  
 */
public interface ComboService {
	/**
	 * Obtiene la lista de municipios en base al código de provincia para cargar un combo
	 * 
	 * @param codProvincia código de la provincia
	 * @return lista de municipios
	 */
	List<Combo> findMunicipiosByProvincia(int codProvincia);

	/**
	 * Obtiene la lista de localidades en base al código de municipio y provincia
	 * 
	 * @param codProvincia código de la provincia
	 * @param codMunicipio código del municipio
	 * 
	 * @return listado de localidades
	 */
	List<Combo> findLocalidadesByMunicipio(int codProvincia, int codMunicipio);

	/**
	 * Obtiene el listado de provincias de españa, excepto las de euskadi
	 * 
	 * @return listado de provincias, excepto euskadi
	 */
	List<Combo> findProvincias();

}