package com.ejie.u74a.service;

import java.util.List;

import com.ejie.u74a.model.Articulo;
import com.ejie.u74a.model.CriteriosBusqueda;

/**
 * Interfaz de los servicios de acceso a los datos de artículos.
 * 
 *  
 */
public interface ArticuloService {

	/**
	 * Obtiene los artículos dependiendo del filtro aplicado.
	 * 
	 * @param filtro Clase con los filtros de búsqueda.
	 * 
	 * @return lista con los artículos.
	 */
	List<Articulo> findByCriteria(CriteriosBusqueda filtro);

	/**
	 * Obtiene el número de los artículos que cumplen del filtro aplicado.
	 * 
	 * @param filtro Clase con los filtros de búsqueda.
	 * 
	 * @return int número de los artículos que cumplen el filtro aplicado.
	 */
	int findByCountCriteria(CriteriosBusqueda filtro);

	/**
	 * Obtiene los datos del artículo correspondientes al codigo proporcionado.
	 * 
	 * @param codigoArticulo Código del artículo.
	 * 
	 * @return objeto {@link Articulo} con los datos del artículo.
	 */
	Articulo findByCodigo(int codigoArticulo);

	/**
	 * Obtiene los datos del artículo correspondientes al codigo proporcionado con información extra.
	 * 
	 * @param codigoArticulo Código del artículo.
	 * 
	 * @return objeto {@link Articulo} con los datos del artículo.
	 */
	Articulo findByCodigoExtra(int codigoArticulo);

	/**
	 * Actualizar el artículo con los datos proporcionados.
	 * 
	 * @param articulo objeto {@link Articulo} con la información.
	 * @return String mensaje con resultado OK si ha ido bien.
	 */
	Articulo actualizarArticulo(Articulo articulo);

	/**
	 * Inserta un nuevo artículo.
	 * 
	 * @param articulo objeto {@link Articulo} con la información.
	 * @return String mensaje con resultado OK si ha ido bien y el codigo del artículo creado.
	 */
	Articulo insertarArticulo(Articulo articulo);

	/**
	 * Borra el artículo y sus idiomas para el código de artículo proporcionado.
	 * 
	 * @param codigoArticulo El código del artículo a eliminar.
	 * @param validarPdtes Indica si hay que validar las peticiones pendientes a S, en otro caso no valida.
	 * @return String mensaje con resultado OK si ha ido bien.
	 */
	String borrarArticuloIdiomas(int codigoArticulo, String validarPdtes);

	/**
	 * Actualiza la información de stock del artículo.
	 * 
	 * @param articulo objeto {@link Articulo} con la información.
	 * @return String mensaje con resultado OK si ha ido bien
	 */
	String actualizarInfoStockArticulo(Articulo articulo);

}