package com.ejie.u74a.model;

import java.util.Collection;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

/**
 * Clase que contiene los datos un usuario que se mantendrán en el contexto de seguridad
 * 
 *  
 */
public class UsuarioDetalles extends User {

	private static final long serialVersionUID = 6008232749717393542L;

	/** Código de oficina. */
	private String codigoOficina;

	/** Nombre y apellido o descripción. */
	private String nombre;

	/** login. */
	private String login;

	/** URL al manual. */
	private String urlManual;

	/**
	 * Constructor.
	 * 
	 * @param userName Código usado para la autenticación del usuario
	 * @param password Password
	 * @param authorities Autorizaciones del usuario
	 * @param codigoOficina Código de oficina
	 * @param nombre Nombre
	 * @param login Login
	 */
	public UsuarioDetalles(String userName, String password, Collection<? extends GrantedAuthority> authorities,
			String codigoOficina, String nombre, String login) {
		super(userName, password, authorities);

		this.codigoOficina = codigoOficina;
		this.nombre = nombre;
		this.login = login;
	}

	/**
	 * Obtiene el campo codigoOficina.
	 * 
	 * @return codigoOficina
	 */
	public String getCodigoOficina() {
		return this.codigoOficina;
	}

	/**
	 * Establece el campo codigoOficina.
	 * 
	 * @param codigoOficina codigoOficina
	 */
	public void setCodigoOficina(String codigoOficina) {
		this.codigoOficina = codigoOficina;
	}

	/**
	 * Obtiene el campo nombre.
	 * 
	 * @return nombre
	 */
	public String getNombre() {
		return this.nombre;
	}

	/**
	 * Establece el campo nombre.
	 * 
	 * @param nombre nombre
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Obtiene el campo login.
	 * 
	 * @return login
	 */
	public String getLogin() {
		return this.login;
	}

	/**
	 * Establece el campo login.
	 * 
	 * @param login login
	 */
	public void setLogin(String login) {
		this.login = login;
	}

	/**
	 * Obtiene el campo urlManual
	 * 
	 * @return urlManual
	 */
	public String getUrlManual() {
		return this.urlManual;
	}

	/**
	 * Establece el campo urlManual
	 * 
	 * @param urlManual urlManual
	 */
	public void setUrlManual(String urlManual) {
		this.urlManual = urlManual;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override()
	public String toString() {
		return "UsuarioDetalles [codigoUsuario=" + this.getUsername() + ", login=" + this.login + ", nombre="
				+ this.nombre + ", codigoOficina=" + this.codigoOficina + "]";
	}

}
