package com.ejie.u74a.model;

import java.util.ArrayList;
import java.util.List;

/**
 * Clase que representa un usuario de la aplicación
 * 
 *  
 */
public class Usuario {

	/** Código de usuario. */
	private int codigoUsuario;

	/** Código de oficina. */
	private String codigoOficina;

	/** Nombre y apellido o descripción. */
	private String nombre;

	/** Cargo. */
	private String cargo;

	/** Número de teléfono. */
	private String telefono;

	/** Número de fax. */
	private String fax;

	/** email. */
	private String email;

	/** login. */
	private String login;

	/** password. */
	private String password;

	/** Perfiles del usuario. */
	private List<PerfilUsuario> perfilesUsuario = new ArrayList<PerfilUsuario>();

	/**
	 * Constructor por defecto
	 */
	public Usuario() {

	}

	/**
	 * Constructor.
	 * 
	 * @param codigoUsuario Código de usuario
	 * @param codigoOficina Código de oficina
	 * @param nombre Nombre
	 * @param cargo Cargo
	 * @param telefono Teléfono
	 * @param fax Fax
	 * @param email Email
	 * @param login Login
	 * @param password Password
	 */
	public Usuario(int codigoUsuario, String codigoOficina, String nombre, String cargo, String telefono, String fax,
			String email, String login, String password) {
		this.codigoUsuario = codigoUsuario;
		this.codigoOficina = codigoOficina;
		this.nombre = nombre;
		this.cargo = cargo;
		this.telefono = telefono;
		this.fax = fax;
		this.email = email;
		this.login = login;
		this.password = password;
	}

	/**
	 * Obtiene el campo codigoUsuario.
	 * 
	 * @return codigoUsuario
	 */
	public int getCodigoUsuario() {
		return this.codigoUsuario;
	}

	/**
	 * Establece el campo codigoUsuario.
	 * 
	 * @param codigoUsuario codigoUsuario
	 */
	public void setCodigoUsuario(int codigoUsuario) {
		this.codigoUsuario = codigoUsuario;
	}

	/**
	 * Obtiene el campo codigoOficina.
	 * 
	 * @return codigoOficina
	 */
	public String getCodigoOficina() {
		return this.codigoOficina;
	}

	/**
	 * Establece el campo codigoOficina.
	 * 
	 * @param codigoOficina codigoOficina
	 */
	public void setCodigoOficina(String codigoOficina) {
		this.codigoOficina = codigoOficina;
	}

	/**
	 * Obtiene el campo nombre.
	 * 
	 * @return nombre
	 */
	public String getNombre() {
		return this.nombre;
	}

	/**
	 * Establece el campo nombre.
	 * 
	 * @param nombre nombre
	 */
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Obtiene el campo cargo.
	 * 
	 * @return cargo
	 */
	public String getCargo() {
		return this.cargo;
	}

	/**
	 * Establece el campo cargo.
	 * 
	 * @param cargo cargo
	 */
	public void setCargo(String cargo) {
		this.cargo = cargo;
	}

	/**
	 * Obtiene el campo telefono.
	 * 
	 * @return telefono
	 */
	public String getTelefono() {
		return this.telefono;
	}

	/**
	 * Establece el campo telefono.
	 * 
	 * @param telefono telefono
	 */
	public void setTelefono(String telefono) {
		this.telefono = telefono;
	}

	/**
	 * Obtiene el campo fax.
	 * 
	 * @return fax
	 */
	public String getFax() {
		return this.fax;
	}

	/**
	 * Establece el campo fax.
	 * 
	 * @param fax fax
	 */
	public void setFax(String fax) {
		this.fax = fax;
	}

	/**
	 * Obtiene el campo email.
	 * 
	 * @return email
	 */
	public String getEmail() {
		return this.email;
	}

	/**
	 * Establece el campo email.
	 * 
	 * @param email email
	 */
	public void setEmail(String email) {
		this.email = email;
	}

	/**
	 * Obtiene el campo login.
	 * 
	 * @return login
	 */
	public String getLogin() {
		return this.login;
	}

	/**
	 * Establece el campo login.
	 * 
	 * @param login login
	 */
	public void setLogin(String login) {
		this.login = login;
	}

	/**
	 * Obtiene el campo password.
	 * 
	 * @return password
	 */
	public String getPassword() {
		return this.password;
	}

	/**
	 * Establece el campo password.
	 * 
	 * @param password password
	 */
	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * Obtiene el campo perfilesUsuario
	 * 
	 * @return perfilesUsuario
	 */
	public List<PerfilUsuario> getPerfilesUsuario() {
		return this.perfilesUsuario;
	}

	/**
	 * Establece el campo perfilesUsuario
	 * 
	 * @param perfilesUsuario perfilesUsuario
	 */
	public void setPerfilesUsuario(List<PerfilUsuario> perfilesUsuario) {
		this.perfilesUsuario = perfilesUsuario;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override()
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + this.codigoUsuario;
		result = prime * result + ((this.login == null) ? 0 : this.login.hashCode());
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override()
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (!(obj instanceof Usuario)) {
			return false;
		}
		Usuario other = (Usuario) obj;
		if (this.codigoUsuario != other.codigoUsuario) {
			return false;
		}
		if (this.login == null) {
			if (other.login != null) {
				return false;
			}
		} else if (!this.login.equals(other.login)) {
			return false;
		}
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override()
	public String toString() {
		return "Usuario [codigoUsuario=" + this.codigoUsuario + ", login=" + this.login + ", nombre=" + this.nombre
				+ ", cargo=" + this.cargo + ", email=" + this.email + ", perfilesUsuario=" + this.perfilesUsuario + "]";
	}

}
