package com.ejie.u74a.model;

import java.util.ArrayList;
import java.util.List;

/**
 * Clase que representa una ubicación con todos sus peticiones asociadas. Utilizada para generar el informe para el
 * almacén.
 * 
 *  
 */
public class UbicacionInforme {

	/** Código de la ubicación. */
	private int codigoUbicacion;

	/** Nombre de la oficina cuyo punto de recepción es la ubicación. */
	private String nombreOficina;

	/** Nombre de la ubicación. */
	private String nombreUbicacion;
	/** Dirección de la ubicación. */
	private String direccion;
	/** Código postal de la ubicación. */
	private String codigoPostal;
	/** Observaciones de la ubicación. */

	/** Nombre de la provincia de la ubicación. */
	private String nombreProvincia;
	/** Nombre del municipio de la ubicación. */
	private String nombreMunicipio;

	/** Extranjero. Determina si la ubicación es extranjera */
	private Integer extranjero;
	/** Dirección extranjera */
	private String direccionExtranjero;

	/** Peticiones asociadas a esa ubicación */
	private List<PeticionInforme> peticionesInforme = new ArrayList<PeticionInforme>();

	/**
	 * Obtiene el campo codigoUbicacion
	 * 
	 * @return codigoUbicacion
	 */
	public int getCodigoUbicacion() {
		return this.codigoUbicacion;
	}

	/**
	 * Establece el campo codigoUbicacion
	 * 
	 * @param codigoUbicacion codigoUbicacion
	 */
	public void setCodigoUbicacion(int codigoUbicacion) {
		this.codigoUbicacion = codigoUbicacion;
	}

	/**
	 * Obtiene el campo nombreOficina
	 * 
	 * @return nombreOficina
	 */
	public String getNombreOficina() {
		return this.nombreOficina;
	}

	/**
	 * Establece el campo nombreOficina
	 * 
	 * @param nombreOficina nombreOficina
	 */
	public void setNombreOficina(String nombreOficina) {
		this.nombreOficina = nombreOficina;
	}

	/**
	 * Obtiene el campo nombreUbicacion
	 * 
	 * @return nombreUbicacion
	 */
	public String getNombreUbicacion() {
		return this.nombreUbicacion;
	}

	/**
	 * Establece el campo nombreUbicacion
	 * 
	 * @param nombreUbicacion nombreUbicacion
	 */
	public void setNombreUbicacion(String nombreUbicacion) {
		this.nombreUbicacion = nombreUbicacion;
	}

	/**
	 * Obtiene el campo direccion
	 * 
	 * @return direccion
	 */
	public String getDireccion() {
		return this.direccion;
	}

	/**
	 * Establece el campo direccion
	 * 
	 * @param direccion direccion
	 */
	public void setDireccion(String direccion) {
		this.direccion = direccion;
	}

	/**
	 * Obtiene el campo codigoPostal
	 * 
	 * @return codigoPostal
	 */
	public String getCodigoPostal() {
		return this.codigoPostal;
	}

	/**
	 * Establece el campo codigoPostal
	 * 
	 * @param codigoPostal codigoPostal
	 */
	public void setCodigoPostal(String codigoPostal) {
		this.codigoPostal = codigoPostal;
	}

	/**
	 * Obtiene el campo nombreProvincia
	 * 
	 * @return nombreProvincia
	 */
	public String getNombreProvincia() {
		return this.nombreProvincia;
	}

	/**
	 * Establece el campo nombreProvincia
	 * 
	 * @param nombreProvincia nombreProvincia
	 */
	public void setNombreProvincia(String nombreProvincia) {
		this.nombreProvincia = nombreProvincia;
	}

	/**
	 * Obtiene el campo nombreMunicipio
	 * 
	 * @return nombreMunicipio
	 */
	public String getNombreMunicipio() {
		return this.nombreMunicipio;
	}

	/**
	 * Establece el campo nombreMunicipio
	 * 
	 * @param nombreMunicipio nombreMunicipio
	 */
	public void setNombreMunicipio(String nombreMunicipio) {
		this.nombreMunicipio = nombreMunicipio;
	}

	/**
	 * Obtiene el campo peticionesInforme
	 * 
	 * @return peticionesInforme
	 */
	public List<PeticionInforme> getPeticionesInforme() {
		return this.peticionesInforme;
	}

	/**
	 * Establece el campo peticionesInforme
	 * 
	 * @param peticionesInforme peticionesInforme
	 */
	public void setPeticionesInforme(List<PeticionInforme> peticionesInforme) {
		this.peticionesInforme = peticionesInforme;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override()
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + this.codigoUbicacion;
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override()
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (!(obj instanceof UbicacionInforme)) {
			return false;
		}
		UbicacionInforme other = (UbicacionInforme) obj;
		if (this.codigoUbicacion != other.codigoUbicacion) {
			return false;
		}
		return true;
	}

	/**
	 * Obtiene el campo extranjero
	 * 
	 * @return extranjero
	 */
	public Integer getExtranjero() {
		return this.extranjero;
	}

	/**
	 * Establece el campo extranjero
	 * 
	 * @param extranjero extranjero
	 */
	public void setExtranjero(Integer extranjero) {
		this.extranjero = extranjero;
	}

	/**
	 * Obtiene el campo direccionExtranjero
	 * 
	 * @return direccionExtranjero
	 */
	public String getDireccionExtranjero() {
		return this.direccionExtranjero;
	}

	/**
	 * Establece el campo direccionExtranjero
	 * 
	 * @param direccionExtranjero direccionExtranjero
	 */
	public void setDireccionExtranjero(String direccionExtranjero) {
		this.direccionExtranjero = direccionExtranjero;
	}

}
