package com.ejie.u74a.model;

import java.util.HashMap;
import java.util.Map;

/**
 * Enumerado con los tipos de perfil definidos por la aplicación
 * 
 *  
 */
public enum TipoPerfilUsuario {

	/**
	 * Gestor. Tiene acceso a la parte de gestión de catálogos y stocks del Departamento. Son GESTORES los usuarios con
	 * perfil de Coordinador de Red y los usuarios con perfil de Administrador de Oficina pertenecientes a la oficina
	 * del Departamento: 1C028 - GOBIERNO VASCO - DIRECCION DE PROMOCION TURISTICA
	 * 
	 */
	GESTOR("GESTOR"),

	/**
	 * Usuario. Solo tiene acceso a la solicitud de folletos. Son USUARIOS los usuarios con perfil Usuario de Red,
	 * Administrador Area Conocimiento, Administrador Grupos de Trabajo y Administrador de Oficina que no pertenezcan a
	 * la oficina del Departamento: 1C028 - GOBIERNO VASCO - DIRECCION DE PROMOCION TURISTICA
	 * 
	 */
	USUARIO("USUARIO");

	/** Tipo de perfil */
	private String tipoPerfilUsuario;

	// Coordinador de Red
	private static final int COORDINADOR = 1;

	// Administrador de Oficina
	private static final int ADMINISTRADOR_OFICINA = 2;

	// Usuario de Red
	private static final int USUARIO_RED = 3;

	// Administrador Area Conocimiento
	private static final int ADMINISTRADOR_AREA_CONOCIMIENTO = 4;

	// Administrador Grupos de Trabajo
	private static final int ADMINISTRADOR_GRUPOS_TRABAJO = 5;

	/**
	 * Mapeo del código de perfil de BBDD con el valor del enumerado correspondiente
	 */
	private static final Map<Integer, TipoPerfilUsuario> lookup = new HashMap<Integer, TipoPerfilUsuario>();

	static {
		lookup.put(COORDINADOR, GESTOR);
		lookup.put(ADMINISTRADOR_OFICINA, USUARIO);
		lookup.put(USUARIO_RED, USUARIO);
		lookup.put(ADMINISTRADOR_AREA_CONOCIMIENTO, USUARIO);
		lookup.put(ADMINISTRADOR_GRUPOS_TRABAJO, USUARIO);
	}

	/**
	 * Instancia un nuevo tipo de perfil.
	 * 
	 * @param tipoPerfilUsuario Tipo de perfil
	 */
	private TipoPerfilUsuario(String tipoPerfilUsuario) {
		this.tipoPerfilUsuario = tipoPerfilUsuario;
	}

	/**
	 * Obtiene el tipo de perfil
	 * 
	 * @return tipo de perfil
	 */
	public String getTipoPerfilUsuario() {
		return this.tipoPerfilUsuario;
	}

	/**
	 * Obtiene el valor del enumerado a partir del código de perfil
	 * 
	 * @param codigoPerfil Código de perfil
	 * 
	 * @return valor del enumerado correspondiente al código de perfil
	 */
	public static TipoPerfilUsuario get(int codigoPerfil) {
		return lookup.get(codigoPerfil);
	}

}
