package com.ejie.u74a.model;

import java.util.Locale;

/**
 * Clase que representa un tipo de material de la aplicación.
 * 
 *  
 */
public class TipoMaterial {

	/** Código de tipo de material. */
	private int codigo;

	/** Nombre en castellano. */
	private String nombreCastellano;

	/** Nombre en euskera. */
	private String nombreEuskera;

	/** Abreviatura en castellano. */
	private String abreviaturaCastellano;

	/** Abreviatura en euskera. */
	private String abreviaturaEuskera;

	/**
	 * Obtiene el campo codigo
	 * 
	 * @return codigo
	 */
	public int getCodigo() {
		return this.codigo;
	}

	/**
	 * Establece el campo codigo
	 * 
	 * @param codigo codigo
	 */
	public void setCodigo(int codigo) {
		this.codigo = codigo;
	}

	/**
	 * Obtiene el campo nombreCastellano
	 * 
	 * @return nombreCastellano
	 */
	public String getNombreCastellano() {
		return this.nombreCastellano;
	}

	/**
	 * Establece el campo nombreCastellano
	 * 
	 * @param nombreCastellano nombreCastellano
	 */
	public void setNombreCastellano(String nombreCastellano) {
		this.nombreCastellano = nombreCastellano;
	}

	/**
	 * Obtiene el campo nombreEuskera
	 * 
	 * @return nombreEuskera
	 */
	public String getNombreEuskera() {
		return this.nombreEuskera;
	}

	/**
	 * Establece el campo nombreEuskera
	 * 
	 * @param nombreEuskera nombreEuskera
	 */
	public void setNombreEuskera(String nombreEuskera) {
		this.nombreEuskera = nombreEuskera;
	}

	/**
	 * Obtiene el campo abreviaturaCastellano
	 * 
	 * @return abreviaturaCastellano
	 */
	public String getAbreviaturaCastellano() {
		return this.abreviaturaCastellano;
	}

	/**
	 * Establece el campo abreviaturaCastellano
	 * 
	 * @param abreviaturaCastellano abreviaturaCastellano
	 */
	public void setAbreviaturaCastellano(String abreviaturaCastellano) {
		this.abreviaturaCastellano = abreviaturaCastellano;
	}

	/**
	 * Obtiene el campo abreviaturaEuskera
	 * 
	 * @return abreviaturaEuskera
	 */
	public String getAbreviaturaEuskera() {
		return this.abreviaturaEuskera;
	}

	/**
	 * Establece el campo abreviaturaEuskera
	 * 
	 * @param abreviaturaEuskera abreviaturaEuskera
	 */
	public void setAbreviaturaEuskera(String abreviaturaEuskera) {
		this.abreviaturaEuskera = abreviaturaEuskera;
	}

	/**
	 * Obtiene el campo abreviatura en función del locale.
	 * 
	 * @param locale locale
	 * 
	 * @return abreviatura
	 */
	public String getAbreviatura(Locale locale) {
		if (new Locale("eu").equals(locale)) {
			return this.abreviaturaEuskera;
		} else {
			return this.abreviaturaCastellano;
		}

	}

	/**
	 * Obtiene el campo nombre en función del locale.
	 * 
	 * @param locale locale
	 * 
	 * @return nombre
	 */
	public String getNombre(Locale locale) {
		if (new Locale("eu").equals(locale)) {
			return this.nombreEuskera;
		} else {
			return this.nombreCastellano;
		}

	}

}
