package com.ejie.u74a.model;

import java.util.Locale;

/**
 * Clase que representa un tema asociado a un tipo de material.
 * 
 *  
 */
public class TemaMaterial {

	/** Código de tema de material. */
	private int codigoTemaMaterial;

	/** Código de tipo de material. */
	private int codigoTipoMaterial;

	/** Nombre en castellano. */
	private String nombreCastellano;

	/** Nombre en euskera. */
	private String nombreEuskera;

	/** Indica si es el tema principal. */
	private boolean principal;

	/** Código del material **/
	private int codigoMaterial;

	/**
	 * Obtiene el campo codigoTemaMaterial
	 * 
	 * @return codigoTemaMaterial
	 */
	public int getCodigoTemaMaterial() {
		return this.codigoTemaMaterial;
	}

	/**
	 * Establece el campo codigoTemaMaterial
	 * 
	 * @param codigoTemaMaterial codigoTemaMaterial
	 */
	public void setCodigoTemaMaterial(int codigoTemaMaterial) {
		this.codigoTemaMaterial = codigoTemaMaterial;
	}

	/**
	 * Obtiene el campo codigoMaterial
	 * 
	 * @return codigoMaterial
	 */
	public int getCodigoMaterial() {
		return this.codigoMaterial;
	}

	/**
	 * Establece el campo codigoMaterial
	 * 
	 * @param codigoMaterial codigoMaterial
	 */
	public void setCodigoMaterial(int codigoMaterial) {
		this.codigoMaterial = codigoMaterial;
	}

	/**
	 * Obtiene el campo codigoTipoMaterial
	 * 
	 * @return codigoTipoMaterial
	 */
	public int getCodigoTipoMaterial() {
		return this.codigoTipoMaterial;
	}

	/**
	 * Establece el campo codigoTipoMaterial
	 * 
	 * @param codigoTipoMaterial codigoTipoMaterial
	 */
	public void setCodigoTipoMaterial(int codigoTipoMaterial) {
		this.codigoTipoMaterial = codigoTipoMaterial;
	}

	/**
	 * Obtiene el campo nombreCastellano
	 * 
	 * @return nombreCastellano
	 */
	public String getNombreCastellano() {
		return this.nombreCastellano;
	}

	/**
	 * Establece el campo nombreCastellano
	 * 
	 * @param nombreCastellano nombreCastellano
	 */
	public void setNombreCastellano(String nombreCastellano) {
		this.nombreCastellano = nombreCastellano;
	}

	/**
	 * Obtiene el campo nombreEuskera
	 * 
	 * @return nombreEuskera
	 */
	public String getNombreEuskera() {
		return this.nombreEuskera;
	}

	/**
	 * Establece el campo nombreEuskera
	 * 
	 * @param nombreEuskera nombreEuskera
	 */
	public void setNombreEuskera(String nombreEuskera) {
		this.nombreEuskera = nombreEuskera;
	}

	/**
	 * Obtiene el campo principal
	 * 
	 * @return principal
	 */
	public boolean isPrincipal() {
		return this.principal;
	}

	/**
	 * Establece el campo principal
	 * 
	 * @param principal principal
	 */
	public void setPrincipal(boolean principal) {
		this.principal = principal;
	}

	/**
	 * Obtiene el campo nombre en función del locale.
	 * 
	 * @param locale locale
	 * 
	 * @return nombre
	 */
	public String getNombre(Locale locale) {
		if (new Locale("eu").equals(locale)) {
			return this.nombreEuskera;
		} else {
			return this.nombreCastellano;
		}

	}

}
