package com.ejie.u74a.model;

import java.util.Date;

/**
 * Clase que representa un registro de entrada / salida.
 * 
 *  
 */
public class RegistroES {

	/** Código del artículo. */
	private int codigoArticulo;

	/** Código de la oficina almacen. */
	private String codigoOficina;

	/** Fecha de entrada-salida. */
	private Date fechaEntradaSalida;

	/** Tipo de la entrada/Salida E: Entrada, S: Salida. */
	private String tipo;

	/** Subtipo 10: Correccion de Stock (E/S), 21: Peticion de Oficina. */
	private String subtipo;

	/** El código de la petición. */
	private int codigoPeticion;

	/** Número ejemplares. */
	private int numEjemplares;

	// Campos externos
	/** Nombre de la oficina que realiza la entrada / salida */
	private String descripcionOficina;

	/**
	 * Obtiene el campo codigoArticulo
	 * 
	 * @return codigoArticulo
	 */
	public int getCodigoArticulo() {
		return this.codigoArticulo;
	}

	/**
	 * Establece el campo codigoArticulo
	 * 
	 * @param codigoArticulo codigoArticulo
	 */
	public void setCodigoArticulo(int codigoArticulo) {
		this.codigoArticulo = codigoArticulo;
	}

	/**
	 * Obtiene el campo codigoOficina
	 * 
	 * @return codigoOficina
	 */
	public String getCodigoOficina() {
		return this.codigoOficina;
	}

	/**
	 * Establece el campo codigoOficina
	 * 
	 * @param codigoOficina codigoOficina
	 */
	public void setCodigoOficina(String codigoOficina) {
		this.codigoOficina = codigoOficina;
	}

	/**
	 * Obtiene el campo fechaEntradaSalida
	 * 
	 * @return fechaEntradaSalida
	 */
	public Date getFechaEntradaSalida() {
		return this.fechaEntradaSalida;
	}

	/**
	 * Establece el campo fechaEntradaSalida
	 * 
	 * @param fechaEntradaSalida fechaEntradaSalida
	 */
	public void setFechaEntradaSalida(Date fechaEntradaSalida) {
		this.fechaEntradaSalida = fechaEntradaSalida;
	}

	/**
	 * Obtiene el campo tipo
	 * 
	 * @return tipo
	 */
	public String getTipo() {
		return this.tipo;
	}

	/**
	 * Establece el campo tipo
	 * 
	 * @param tipo tipo
	 */
	public void setTipo(String tipo) {
		this.tipo = tipo;
	}

	/**
	 * Obtiene el campo subtipo
	 * 
	 * @return subtipo
	 */
	public String getSubtipo() {
		return this.subtipo;
	}

	/**
	 * Establece el campo subtipo
	 * 
	 * @param subtipo subtipo
	 */
	public void setSubtipo(String subtipo) {
		this.subtipo = subtipo;
	}

	/**
	 * Obtiene el campo codigoPeticion
	 * 
	 * @return codigoPeticion
	 */
	public int getCodigoPeticion() {
		return this.codigoPeticion;
	}

	/**
	 * Establece el campo codigoPeticion
	 * 
	 * @param codigoPeticion codigoPeticion
	 */
	public void setCodigoPeticion(int codigoPeticion) {
		this.codigoPeticion = codigoPeticion;
	}

	/**
	 * Obtiene el campo numEjemplares
	 * 
	 * @return numEjemplares
	 */
	public int getNumEjemplares() {
		return this.numEjemplares;
	}

	/**
	 * Establece el campo numEjemplares
	 * 
	 * @param numEjemplares numEjemplares
	 */
	public void setNumEjemplares(int numEjemplares) {
		this.numEjemplares = numEjemplares;
	}

	/**
	 * Obtiene el campo descripcionOficina
	 * 
	 * @return descripcionOficina
	 */
	public String getDescripcionOficina() {
		return this.descripcionOficina;
	}

	/**
	 * Establece el campo descripcionOficina
	 * 
	 * @param descripcionOficina descripcionOficina
	 */
	public void setDescripcionOficina(String descripcionOficina) {
		this.descripcionOficina = descripcionOficina;
	}

}
