package com.ejie.u74a.model;

/**
 * Clase que representa los datos de una petición que se sacan en el informe para almacén.
 * 
 *  
 */
public class PeticionInforme {

	/** Código de la petición. */
	private int codigoPeticion;

	/** Código del artículo. */
	private int codigoArticulo;

	/** Código del almacén. */
	private String codigoAlmacen;

	/** Marca de aceptada P:Pendiente, A: Aceptada, R: Rechazada. */
	private String estado;

	/** Numero de ejemplares/cajas pedidos. */
	private int numPedido;

	/** El nombre del material ya traducido. */
	private String descripcionMaterial;

	/** Título del material en español. */
	private String tituloCastellano;

	/** Título del material en euskera. */
	private String tituloEuskera;

	/** Indica el tipo de idioma, si es multilingüe, el idioma si es es monolingüe o sin idioma. */
	private String descripcionIdioma;

	/** Número de ejemplares/cajas aceptados */
	private Integer numAceptado;

	/** Comentarios sobre la Petición. */
	private String textoPeticion;

	/** Comentario del punto de recepción. */
	private String textoPuntoRecepcion;

	/**
	 * Obtiene el campo codigoPeticion
	 * 
	 * @return codigoPeticion
	 */
	public int getCodigoPeticion() {
		return this.codigoPeticion;
	}

	/**
	 * Establece el campo codigoPeticion
	 * 
	 * @param codigoPeticion codigoPeticion
	 */
	public void setCodigoPeticion(int codigoPeticion) {
		this.codigoPeticion = codigoPeticion;
	}

	/**
	 * Obtiene el campo codigoArticulo
	 * 
	 * @return codigoArticulo
	 */
	public int getCodigoArticulo() {
		return this.codigoArticulo;
	}

	/**
	 * Establece el campo codigoArticulo
	 * 
	 * @param codigoArticulo codigoArticulo
	 */
	public void setCodigoArticulo(int codigoArticulo) {
		this.codigoArticulo = codigoArticulo;
	}

	/**
	 * Obtiene el campo codigoAlmacen
	 * 
	 * @return codigoAlmacen
	 */
	public String getCodigoAlmacen() {
		return this.codigoAlmacen;
	}

	/**
	 * Establece el campo codigoAlmacen
	 * 
	 * @param codigoAlmacen codigoAlmacen
	 */
	public void setCodigoAlmacen(String codigoAlmacen) {
		this.codigoAlmacen = codigoAlmacen;
	}

	/**
	 * Obtiene el campo estado
	 * 
	 * @return estado
	 */
	public String getEstado() {
		return this.estado;
	}

	/**
	 * Establece el campo estado
	 * 
	 * @param estado estado
	 */
	public void setEstado(String estado) {
		this.estado = estado;
	}

	/**
	 * Obtiene el campo numPedido
	 * 
	 * @return numPedido
	 */
	public int getNumPedido() {
		return this.numPedido;
	}

	/**
	 * Establece el campo numPedido
	 * 
	 * @param numPedido numPedido
	 */
	public void setNumPedido(int numPedido) {
		this.numPedido = numPedido;
	}

	/**
	 * Obtiene el campo descripcionMaterial
	 * 
	 * @return descripcionMaterial
	 */
	public String getDescripcionMaterial() {
		return this.descripcionMaterial;
	}

	/**
	 * Establece el campo descripcionMaterial
	 * 
	 * @param descripcionMaterial descripcionMaterial
	 */
	public void setDescripcionMaterial(String descripcionMaterial) {
		this.descripcionMaterial = descripcionMaterial;
	}

	/**
	 * Obtiene el campo descripcionIdioma
	 * 
	 * @return descripcionIdioma
	 */
	public String getDescripcionIdioma() {
		return this.descripcionIdioma;
	}

	/**
	 * Establece el campo descripcionIdioma
	 * 
	 * @param descripcionIdioma descripcionIdioma
	 */
	public void setDescripcionIdioma(String descripcionIdioma) {
		this.descripcionIdioma = descripcionIdioma;
	}

	/**
	 * Obtiene el campo tituloCastellano
	 * 
	 * @return tituloCastellano
	 */
	public String getTituloCastellano() {
		return this.tituloCastellano;
	}

	/**
	 * Establece el campo tituloCastellano
	 * 
	 * @param tituloCastellano tituloCastellano
	 */
	public void setTituloCastellano(String tituloCastellano) {
		this.tituloCastellano = tituloCastellano;
	}

	/**
	 * Obtiene el campo tituloEuskera
	 * 
	 * @return tituloEuskera
	 */
	public String getTituloEuskera() {
		return this.tituloEuskera;
	}

	/**
	 * Establece el campo tituloEuskera
	 * 
	 * @param tituloEuskera tituloEuskera
	 */
	public void setTituloEuskera(String tituloEuskera) {
		this.tituloEuskera = tituloEuskera;
	}

	/**
	 * Obtiene el campo textoPeticion
	 * 
	 * @return textoPeticion
	 */
	public String getTextoPeticion() {
		return this.textoPeticion;
	}

	/**
	 * Establece el campo textoPeticion
	 * 
	 * @param textoPeticion textoPeticion
	 */
	public void setTextoPeticion(String textoPeticion) {
		this.textoPeticion = textoPeticion;
	}

	/**
	 * Obtiene el campo textoPuntoRecepcion
	 * 
	 * @return textoPuntoRecepcion
	 */
	public String getTextoPuntoRecepcion() {
		return this.textoPuntoRecepcion;
	}

	/**
	 * Establece el campo textoPuntoRecepcion
	 * 
	 * @param textoPuntoRecepcion textoPuntoRecepcion
	 */
	public void setTextoPuntoRecepcion(String textoPuntoRecepcion) {
		this.textoPuntoRecepcion = textoPuntoRecepcion;
	}

	/**
	 * Obtiene el campo numAceptado
	 * 
	 * @return numAceptado
	 */
	public Integer getNumAceptado() {
		return this.numAceptado;
	}

	/**
	 * Establece el campo numAceptado
	 * 
	 * @param numAceptado numAceptado
	 */
	public void setNumAceptado(Integer numAceptado) {
		this.numAceptado = numAceptado;
	}

}