package com.ejie.u74a.model;

import java.util.Date;

/**
 * Clase que representa una petición.
 * 
 *  
 */
public class Peticion {

	/** Código de la petición. */
	private int codigoPeticion;
	/** Código del artículo. */
	private int codigoArticulo;
	/** Fecha de la petición. */
	private Date fechaPeticion;
	/** Numero de ejemplares/cajas pedidos. */
	private int numPedido;
	/** Número de ejemplares/cajas aceptados */
	private int numAceptado;
	/** Numero ejemplares por caja, si Null: el pedido es en ejemplares, si no Null: el pedido es por cajas. */
	private int numEjemplaresCaja;
	/** Código forma de envío. */
	private int codigoFormaEnvio;
	/** Comentarios sobre la Petición. */
	private String textoPeticion;
	/**
	 * Código del solicitante, Oficina de la red Itourbask.
	 */
	private String codigoSolicitante;
	/** Código de ubicación o punto de recepción. */
	private int codigoUbicacion;
	/** Comentario del punto de recepción. */
	private String textoPuntoRecepcion;
	/** Fecha de aceptación. */
	private Date fechaEstado;
	/** Marca de aceptada P:Pentiente,A: Aceptada,R: Rechazada. */
	private String estado;
	/** Fecha de modificación. */
	private Date fechaModificacion;
	/** Código de usuario que realiza la modificación. */
	private int codigoUsuarioModificador;

	// Campos externos
	/** El nombre de la oficina solicitante. */
	private String descripcionSolicitante;

	/** El nombre del material ya traducido. */
	private String descripcionMaterial;

	/** Título del material en español. */
	private String tituloCastellano;

	/** Título del material en euskera. */
	private String tituloEuskera;

	/** La abreviatura del tipo de material ya traducida. */
	private String descripcionTipo;

	/** El nombre del estado ya traducido. */
	private String descripcionEstado;

	/** Indica el tipo de idioma, si es multilingüe, el idioma si es es monolingüe o sin idioma. */
	private String descripcionIdioma;

	/** Datos de la ubicación del punto de recepción del pedido */
	private Ubicacion ubicacion;

	/**
	 * Obtiene el campo codigoPeticion
	 * 
	 * @return codigoPeticion
	 */
	public int getCodigoPeticion() {
		return this.codigoPeticion;
	}

	/**
	 * Establece el campo codigoPeticion
	 * 
	 * @param codigoPeticion codigoPeticion
	 */
	public void setCodigoPeticion(int codigoPeticion) {
		this.codigoPeticion = codigoPeticion;
	}

	/**
	 * Obtiene el campo codigoArticulo
	 * 
	 * @return codigoArticulo
	 */
	public int getCodigoArticulo() {
		return this.codigoArticulo;
	}

	/**
	 * Establece el campo codigoArticulo
	 * 
	 * @param codigoArticulo codigoArticulo
	 */
	public void setCodigoArticulo(int codigoArticulo) {
		this.codigoArticulo = codigoArticulo;
	}

	/**
	 * Obtiene el campo fechaPeticion
	 * 
	 * @return fechaPeticion
	 */
	public Date getFechaPeticion() {
		return this.fechaPeticion;
	}

	/**
	 * Establece el campo fechaPeticion
	 * 
	 * @param fechaPeticion fechaPeticion
	 */
	public void setFechaPeticion(Date fechaPeticion) {
		this.fechaPeticion = fechaPeticion;
	}

	/**
	 * Obtiene el campo numPedido
	 * 
	 * @return numPedido
	 */
	public int getNumPedido() {
		return this.numPedido;
	}

	/**
	 * Establece el campo numPedido
	 * 
	 * @param numPedido numPedido
	 */
	public void setNumPedido(int numPedido) {
		this.numPedido = numPedido;
	}

	/**
	 * Obtiene el campo numEjemplaresCaja
	 * 
	 * @return numEjemplaresCaja
	 */
	public int getNumEjemplaresCaja() {
		return this.numEjemplaresCaja;
	}

	/**
	 * Establece el campo numEjemplaresCaja
	 * 
	 * @param numEjemplaresCaja numEjemplaresCaja
	 */
	public void setNumEjemplaresCaja(int numEjemplaresCaja) {
		this.numEjemplaresCaja = numEjemplaresCaja;
	}

	/**
	 * Obtiene el campo codigoFormaEnvio
	 * 
	 * @return codigoFormaEnvio
	 */
	public int getCodigoFormaEnvio() {
		return this.codigoFormaEnvio;
	}

	/**
	 * Establece el campo codigoFormaEnvio
	 * 
	 * @param codigoFormaEnvio codigoFormaEnvio
	 */
	public void setCodigoFormaEnvio(int codigoFormaEnvio) {
		this.codigoFormaEnvio = codigoFormaEnvio;
	}

	/**
	 * Obtiene el campo textoPeticion
	 * 
	 * @return textoPeticion
	 */
	public String getTextoPeticion() {
		return this.textoPeticion;
	}

	/**
	 * Establece el campo textoPeticion
	 * 
	 * @param textoPeticion textoPeticion
	 */
	public void setTextoPeticion(String textoPeticion) {
		this.textoPeticion = textoPeticion;
	}

	/**
	 * Obtiene el campo codigoSolicitante
	 * 
	 * @return codigoSolicitante
	 */
	public String getCodigoSolicitante() {
		return this.codigoSolicitante;
	}

	/**
	 * Establece el campo codigoSolicitante
	 * 
	 * @param codigoSolicitante codigoSolicitante
	 */
	public void setCodigoSolicitante(String codigoSolicitante) {
		this.codigoSolicitante = codigoSolicitante;
	}

	/**
	 * Obtiene el campo codigoUbicacion
	 * 
	 * @return codigoUbicacion
	 */
	public int getCodigoUbicacion() {
		return this.codigoUbicacion;
	}

	/**
	 * Establece el campo codigoUbicacion
	 * 
	 * @param codigoUbicacion codigoUbicacion
	 */
	public void setCodigoUbicacion(int codigoUbicacion) {
		this.codigoUbicacion = codigoUbicacion;
	}

	/**
	 * Obtiene el campo textoPuntoRecepcion
	 * 
	 * @return textoPuntoRecepcion
	 */
	public String getTextoPuntoRecepcion() {
		return this.textoPuntoRecepcion;
	}

	/**
	 * Establece el campo textoPuntoRecepcion
	 * 
	 * @param textoPuntoRecepcion textoPuntoRecepcion
	 */
	public void setTextoPuntoRecepcion(String textoPuntoRecepcion) {
		this.textoPuntoRecepcion = textoPuntoRecepcion;
	}

	/**
	 * Obtiene el campo fechaEstado
	 * 
	 * @return fechaEstado
	 */
	public Date getFechaEstado() {
		return this.fechaEstado;
	}

	/**
	 * Establece el campo fechaEstado
	 * 
	 * @param fechaEstado fechaEstado
	 */
	public void setFechaEstado(Date fechaEstado) {
		this.fechaEstado = fechaEstado;
	}

	/**
	 * Obtiene el campo estado
	 * 
	 * @return estado
	 */
	public String getEstado() {
		return this.estado;
	}

	/**
	 * Establece el campo estado
	 * 
	 * @param estado estado
	 */
	public void setEstado(String estado) {
		this.estado = estado;
	}

	/**
	 * Obtiene el campo fechaModificacion
	 * 
	 * @return fechaModificacion
	 */
	public Date getFechaModificacion() {
		return this.fechaModificacion;
	}

	/**
	 * Establece el campo fechaModificacion
	 * 
	 * @param fechaModificacion fechaModificacion
	 */
	public void setFechaModificacion(Date fechaModificacion) {
		this.fechaModificacion = fechaModificacion;
	}

	/**
	 * Obtiene el campo codigoUsuarioModificador
	 * 
	 * @return codigoUsuarioModificador
	 */
	public int getCodigoUsuarioModificador() {
		return this.codigoUsuarioModificador;
	}

	/**
	 * Establece el campo codigoUsuarioModificador
	 * 
	 * @param codigoUsuarioModificador codigoUsuarioModificador
	 */
	public void setCodigoUsuarioModificador(int codigoUsuarioModificador) {
		this.codigoUsuarioModificador = codigoUsuarioModificador;
	}

	/**
	 * Obtiene el campo descripcionSolicitante
	 * 
	 * @return descripcionSolicitante
	 */
	public String getDescripcionSolicitante() {
		return this.descripcionSolicitante;
	}

	/**
	 * Establece el campo descripcionSolicitante
	 * 
	 * @param descripcionSolicitante descripcionSolicitante
	 */
	public void setDescripcionSolicitante(String descripcionSolicitante) {
		this.descripcionSolicitante = descripcionSolicitante;
	}

	/**
	 * Obtiene el campo descripcionMaterial
	 * 
	 * @return descripcionMaterial
	 */
	public String getDescripcionMaterial() {
		return this.descripcionMaterial;
	}

	/**
	 * Establece el campo descripcionMaterial
	 * 
	 * @param descripcionMaterial descripcionMaterial
	 */
	public void setDescripcionMaterial(String descripcionMaterial) {
		this.descripcionMaterial = descripcionMaterial;
	}

	/**
	 * Obtiene el campo descripcionTipo
	 * 
	 * @return descripcionTipo
	 */
	public String getDescripcionTipo() {
		return this.descripcionTipo;
	}

	/**
	 * Establece el campo descripcionTipo
	 * 
	 * @param descripcionTipo descripcionTipo
	 */
	public void setDescripcionTipo(String descripcionTipo) {
		this.descripcionTipo = descripcionTipo;
	}

	/**
	 * Obtiene el campo descripcionEstado
	 * 
	 * @return descripcionEstado
	 */
	public String getDescripcionEstado() {
		return this.descripcionEstado;
	}

	/**
	 * Establece el campo descripcionEstado
	 * 
	 * @param descripcionEstado descripcionEstado
	 */
	public void setDescripcionEstado(String descripcionEstado) {
		this.descripcionEstado = descripcionEstado;
	}

	/**
	 * Obtiene el campo descripcionIdioma
	 * 
	 * @return descripcionIdioma
	 */
	public String getDescripcionIdioma() {
		return this.descripcionIdioma;
	}

	/**
	 * Establece el campo descripcionIdioma
	 * 
	 * @param descripcionIdioma descripcionIdioma
	 */
	public void setDescripcionIdioma(String descripcionIdioma) {
		this.descripcionIdioma = descripcionIdioma;
	}

	/**
	 * Obtiene el campo tituloCastellano
	 * 
	 * @return tituloCastellano
	 */
	public String getTituloCastellano() {
		return this.tituloCastellano;
	}

	/**
	 * Establece el campo tituloCastellano
	 * 
	 * @param tituloCastellano tituloCastellano
	 */
	public void setTituloCastellano(String tituloCastellano) {
		this.tituloCastellano = tituloCastellano;
	}

	/**
	 * Obtiene el campo tituloEuskera
	 * 
	 * @return tituloEuskera
	 */
	public String getTituloEuskera() {
		return this.tituloEuskera;
	}

	/**
	 * Establece el campo tituloEuskera
	 * 
	 * @param tituloEuskera tituloEuskera
	 */
	public void setTituloEuskera(String tituloEuskera) {
		this.tituloEuskera = tituloEuskera;
	}

	/**
	 * Obtiene el campo ubicacion
	 * 
	 * @return ubicacion
	 */
	public Ubicacion getUbicacion() {
		return this.ubicacion;
	}

	/**
	 * Establece el campo ubicacion
	 * 
	 * @param ubicacion ubicacion
	 */
	public void setUbicacion(Ubicacion ubicacion) {
		this.ubicacion = ubicacion;
	}

	/**
	 * Obtiene el campo numAceptado
	 * 
	 * @return numAceptado
	 */
	public int getNumAceptado() {
		return this.numAceptado;
	}

	/**
	 * Establece el campo numAceptado
	 * 
	 * @param numAceptado numAceptado
	 */
	public void setNumAceptado(int numAceptado) {
		this.numAceptado = numAceptado;
	}

}