package com.ejie.u74a.model;

/**
 * Clase que representa los perfiles de la aplicación
 * 
 *  
 */
public class PerfilUsuario {

	/** Código de perfil. */
	private int codigoPerfil;

	/** Tipo de perfil. */
	private String tipoPerfil;

	/**
	 * Constructor
	 * 
	 * @param codigoPerfil Código de perfil
	 * @param tipoPerfil Tipo de perfil
	 */
	public PerfilUsuario(int codigoPerfil, String tipoPerfil) {
		this.codigoPerfil = codigoPerfil;
		this.tipoPerfil = tipoPerfil;
	}

	/**
	 * Obtiene el campo codigoPerfil.
	 * 
	 * @return codigoPerfil
	 */
	public int getCodigoPerfil() {
		return this.codigoPerfil;
	}

	/**
	 * Establece el campo codigoPerfil.
	 * 
	 * @param codigoPerfil codigoPerfil
	 */
	public void setCodigoPerfil(int codigoPerfil) {
		this.codigoPerfil = codigoPerfil;
	}

	/**
	 * Obtiene el campo tipoPerfil.
	 * 
	 * @return tipoPerfil
	 */
	public String getTipoPerfil() {
		return this.tipoPerfil;
	}

	/**
	 * Establece el campo tipoPerfil.
	 * 
	 * @param tipoPerfil tipoPerfil
	 */
	public void setTipoPerfil(String tipoPerfil) {
		this.tipoPerfil = tipoPerfil;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override()
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + this.codigoPerfil;
		result = prime * result + ((this.tipoPerfil == null) ? 0 : this.tipoPerfil.hashCode());
		return result;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override()
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (!(obj instanceof PerfilUsuario)) {
			return false;
		}
		PerfilUsuario other = (PerfilUsuario) obj;
		if (this.codigoPerfil != other.codigoPerfil) {
			return false;
		}
		if (this.tipoPerfil == null) {
			if (other.tipoPerfil != null) {
				return false;
			}
		} else if (!this.tipoPerfil.equals(other.tipoPerfil)) {
			return false;
		}
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override()
	public String toString() {
		return "PerfilUsuario [codigoPerfil=" + this.codigoPerfil + ",  tipoPerfil=" + this.tipoPerfil + "]";
	}

}
