package com.ejie.u74a.model;

import java.util.Date;
import java.util.List;
import java.util.Locale;

/**
 * Clase que representa un material de la aplicación.
 * 
 *  
 */
public class Material {

	/** Código de material. */
	private int codigoMaterial;

	/** Código de tipo de material. */
	private int codigoTipoMaterial;

	/** Código de la Oficina catalogadora. */
	private String codigoOficinaOrigen;

	/** (S|N) Indicador de material descatalogado. */
	private String descatalogado;

	/** Fecha en que se descatalogó. */
	private Date fechaDescatalogado;

	/** Título del material en español. */
	private String tituloCastellano;

	/** Título del material en euskera. */
	private String tituloEuskera;

	/** (S|N) Indicador de material monolingüe (S) o multi-idioma (N). */
	private String monolingue;

	/** Año de edición. */
	private String anioEdicion;

	/** Código de tema del material */
	private int codigoTema;

	/** Formato de salida (DinA4, 40x42, Posters...). */
	private String formato;

	/** Fecha de modificación. */
	private Date fechaModificacion;

	/** Código de usuario que modificó. */
	private int codigoUsuarioModificacion;

	// A partir de aqui estan los atributos introducidos manualmente que no se corresponden con campos de la base de
	// datos.

	/** Objeto tema asociado con el tema principal. */
	private TemaMaterial tema;

	/** Objeto tipo material asociado. */
	private TipoMaterial tipoMaterial;

	/** Lista de los idiomas en los que está el material. */
	private List<Idioma> idiomasLst;

	/** Lista de los temas del material, incluye el tema principal que tiene el atributo principal a true. */
	private List<TemaMaterial> temasLst;

	/** Lista de artículos del material, cuando es de tipo folleto están desglosados por idioma. */
	private List<Articulo> articulosLst;

	/** El artículo del material cuando es de tipo material promocional. */
	private Articulo articuloPromocional;

	/**
	 * Obtiene el campo codigoMaterial
	 * 
	 * @return codigoMaterial
	 */
	public int getCodigoMaterial() {
		return this.codigoMaterial;
	}

	/**
	 * Establece el campo codigoMaterial
	 * 
	 * @param codigoMaterial codigoMaterial
	 */
	public void setCodigoMaterial(int codigoMaterial) {
		this.codigoMaterial = codigoMaterial;
	}

	/**
	 * Obtiene el campo codigoTipoMaterial
	 * 
	 * @return codigoTipoMaterial
	 */
	public int getCodigoTipoMaterial() {
		return this.codigoTipoMaterial;
	}

	/**
	 * Establece el campo codigoTipoMaterial
	 * 
	 * @param codigoTipoMaterial codigoTipoMaterial
	 */
	public void setCodigoTipoMaterial(int codigoTipoMaterial) {
		this.codigoTipoMaterial = codigoTipoMaterial;
	}

	/**
	 * Obtiene el campo codigoOficinaOrigen
	 * 
	 * @return codigoOficinaOrigen
	 */
	public String getCodigoOficinaOrigen() {
		return this.codigoOficinaOrigen;
	}

	/**
	 * Establece el campo codigoOficinaOrigen
	 * 
	 * @param codigoOficinaOrigen codigoOficinaOrigen
	 */
	public void setCodigoOficinaOrigen(String codigoOficinaOrigen) {
		this.codigoOficinaOrigen = codigoOficinaOrigen;
	}

	/**
	 * Obtiene el campo descatalogado
	 * 
	 * @return descatalogado
	 */
	public String getDescatalogado() {
		return this.descatalogado;
	}

	/**
	 * Establece el campo descatalogado
	 * 
	 * @param descatalogado descatalogado
	 */
	public void setDescatalogado(String descatalogado) {
		this.descatalogado = descatalogado;
	}

	/**
	 * Obtiene el campo fechaDescatalogado
	 * 
	 * @return fechaDescatalogado
	 */
	public Date getFechaDescatalogado() {
		return this.fechaDescatalogado;
	}

	/**
	 * Establece el campo fechaDescatalogado
	 * 
	 * @param fechaDescatalogado fechaDescatalogado
	 */
	public void setFechaDescatalogado(Date fechaDescatalogado) {
		this.fechaDescatalogado = fechaDescatalogado;
	}

	/**
	 * Obtiene el campo tituloCastellano
	 * 
	 * @return tituloCastellano
	 */
	public String getTituloCastellano() {
		return this.tituloCastellano;
	}

	/**
	 * Establece el campo tituloCastellano
	 * 
	 * @param tituloCastellano tituloCastellano
	 */
	public void setTituloCastellano(String tituloCastellano) {
		this.tituloCastellano = tituloCastellano;
	}

	/**
	 * Obtiene el campo tituloEuskera
	 * 
	 * @return tituloEuskera
	 */
	public String getTituloEuskera() {
		return this.tituloEuskera;
	}

	/**
	 * Establece el campo tituloEuskera
	 * 
	 * @param tituloEuskera tituloEuskera
	 */
	public void setTituloEuskera(String tituloEuskera) {
		this.tituloEuskera = tituloEuskera;
	}

	/**
	 * Obtiene el campo monolingue
	 * 
	 * @return monolingue
	 */
	public String getMonolingue() {
		return this.monolingue;
	}

	/**
	 * Establece el campo monolingue
	 * 
	 * @param monolingue monolingue
	 */
	public void setMonolingue(String monolingue) {
		this.monolingue = monolingue;
	}

	/**
	 * Obtiene el campo anioEdicion
	 * 
	 * @return anioEdicion
	 */
	public String getAnioEdicion() {
		return this.anioEdicion;
	}

	/**
	 * Establece el campo anioEdicion
	 * 
	 * @param anioEdicion anioEdicion
	 */
	public void setAnioEdicion(String anioEdicion) {
		this.anioEdicion = anioEdicion;
	}

	/**
	 * Obtiene el campo codigoTema
	 * 
	 * @return codigoTema
	 */
	public int getCodigoTema() {
		return this.codigoTema;
	}

	/**
	 * Establece el campo codigoTema
	 * 
	 * @param codigoTema codigoTema
	 */
	public void setCodigoTema(int codigoTema) {
		this.codigoTema = codigoTema;
	}

	/**
	 * Obtiene el campo formato
	 * 
	 * @return formato
	 */
	public String getFormato() {
		return this.formato;
	}

	/**
	 * Establece el campo formato
	 * 
	 * @param formato formato
	 */
	public void setFormato(String formato) {
		this.formato = formato;
	}

	/**
	 * Obtiene el campo fechaModificacion
	 * 
	 * @return fechaModificacion
	 */
	public Date getFechaModificacion() {
		return this.fechaModificacion;
	}

	/**
	 * Establece el campo fechaModificacion
	 * 
	 * @param fechaModificacion fechaModificacion
	 */
	public void setFechaModificacion(Date fechaModificacion) {
		this.fechaModificacion = fechaModificacion;
	}

	/**
	 * Obtiene el campo codigoUsuarioModificacion
	 * 
	 * @return codigoUsuarioModificacion
	 */
	public int getCodigoUsuarioModificacion() {
		return this.codigoUsuarioModificacion;
	}

	/**
	 * Establece el campo codigoUsuarioModificacion
	 * 
	 * @param codigoUsuarioModificacion codigoUsuarioModificacion
	 */
	public void setCodigoUsuarioModificacion(int codigoUsuarioModificacion) {
		this.codigoUsuarioModificacion = codigoUsuarioModificacion;
	}

	/**
	 * Obtiene el campo tema
	 * 
	 * @return tema
	 */
	public TemaMaterial getTema() {
		return this.tema;
	}

	/**
	 * Establece el campo tema
	 * 
	 * @param tema tema
	 */
	public void setTema(TemaMaterial tema) {
		this.tema = tema;
	}

	/**
	 * Obtiene el campo tipoMaterial
	 * 
	 * @return tipoMaterial
	 */
	public TipoMaterial getTipoMaterial() {
		return this.tipoMaterial;
	}

	/**
	 * Establece el campo tipoMaterial
	 * 
	 * @param tipoMaterial tipoMaterial
	 */
	public void setTipoMaterial(TipoMaterial tipoMaterial) {
		this.tipoMaterial = tipoMaterial;
	}

	/**
	 * Obtiene el campo idiomasLst
	 * 
	 * @return idiomasLst
	 */
	public List<Idioma> getIdiomasLst() {
		return this.idiomasLst;
	}

	/**
	 * Establece el campo idiomasLst
	 * 
	 * @param idiomasLst idiomasLst
	 */
	public void setIdiomasLst(List<Idioma> idiomasLst) {
		this.idiomasLst = idiomasLst;
	}

	/**
	 * Obtiene el campo temasLst
	 * 
	 * @return temasLst
	 */
	public List<TemaMaterial> getTemasLst() {
		return this.temasLst;
	}

	/**
	 * Establece el campo temasLst
	 * 
	 * @param temasLst temasLst
	 */
	public void setTemasLst(List<TemaMaterial> temasLst) {
		this.temasLst = temasLst;
	}

	/**
	 * Obtiene el campo articulosList
	 * 
	 * @return articulosList
	 */
	public List<Articulo> getArticulosLst() {
		return this.articulosLst;
	}

	/**
	 * Establece el campo articulosList
	 * 
	 * @param articulosLst articulosLst
	 */
	public void setArticulosLst(List<Articulo> articulosLst) {
		this.articulosLst = articulosLst;
	}

	/**
	 * Obtiene el campo articuloPromocional
	 * 
	 * @return articuloPromocional
	 */
	public Articulo getArticuloPromocional() {
		return this.articuloPromocional;
	}

	/**
	 * Establece el campo articuloPromocional
	 * 
	 * @param articuloPromocional articuloPromocional
	 */
	public void setArticuloPromocional(Articulo articuloPromocional) {
		this.articuloPromocional = articuloPromocional;
	}

	/**
	 * Obtiene el campo titulo en función del locale.
	 * 
	 * @param locale locale
	 * 
	 * @return titulo
	 */
	public String getTitulo(Locale locale) {
		if (new Locale("eu").equals(locale)) {
			return this.tituloEuskera;
		} else {
			return this.tituloCastellano;
		}
	}

}
