package com.ejie.u74a.model;

import java.util.Locale;

/**
 * Clase que representa un idioma de la aplicación.
 * 
 *  
 */
public class Idioma {

	/** Código de idioma. */
	private String codigo;

	/** Nombre en castellano. */
	private String nombreCastellano;

	/** Nombre en euskera. */
	private String nombreEuskera;

	/**
	 * Obtiene el campo codigo
	 * 
	 * @return codigo
	 */
	public String getCodigo() {
		return this.codigo;
	}

	/**
	 * Establece el campo codigo
	 * 
	 * @param codigo codigo
	 */
	public void setCodigo(String codigo) {
		this.codigo = codigo;
	}

	/**
	 * Obtiene el campo nombreCastellano
	 * 
	 * @return nombreCastellano
	 */
	public String getNombreCastellano() {
		return this.nombreCastellano;
	}

	/**
	 * Establece el campo nombreCastellano
	 * 
	 * @param nombreCastellano nombreCastellano
	 */
	public void setNombreCastellano(String nombreCastellano) {
		this.nombreCastellano = nombreCastellano;
	}

	/**
	 * Obtiene el campo nombreEuskera
	 * 
	 * @return nombreEuskera
	 */
	public String getNombreEuskera() {
		return this.nombreEuskera;
	}

	/**
	 * Establece el campo nombreEuskera
	 * 
	 * @param nombreEuskera nombreEuskera
	 */
	public void setNombreEuskera(String nombreEuskera) {
		this.nombreEuskera = nombreEuskera;
	}

	/**
	 * Obtiene el campo nombre en función del locale.
	 * 
	 * @param locale locale
	 * 
	 * @return nombre
	 */
	public String getNombre(Locale locale) {
		if (new Locale("eu").equals(locale)) {
			return this.nombreEuskera;
		} else {
			return this.nombreCastellano;
		}

	}

}
