package com.ejie.u74a.model;

import java.util.Locale;

/**
 * Clase que representa una forma de envío.
 * 
 *  
 */
public class FormaEnvio {
	/** Código de la forma de envío. */
	private int codigoFormaEnvio;
	/** Código de la oficina de envío. */
	private String codigoOrigen; // TODO revisar, esto sobra, solo va a haber una oficina de envio??
	/** Nombre de la forma de envío en castellano. */
	private String nombreFormaEnvioCastellano;
	/** Nombre de la forma de envío en euskera. */
	private String nombreFormaEnvioEuskera;

	/**
	 * Obtiene el campo codigoFormaEnvio
	 * 
	 * @return codigoFormaEnvio
	 */
	public int getCodigoFormaEnvio() {
		return this.codigoFormaEnvio;
	}

	/**
	 * Establece el campo codigoFormaEnvio
	 * 
	 * @param codigoFormaEnvio codigoFormaEnvio
	 */
	public void setCodigoFormaEnvio(int codigoFormaEnvio) {
		this.codigoFormaEnvio = codigoFormaEnvio;
	}

	/**
	 * Obtiene el campo codigoOrigen
	 * 
	 * @return codigoOrigen
	 */
	public String getCodigoOrigen() {
		return this.codigoOrigen;
	}

	/**
	 * Establece el campo codigoOrigen
	 * 
	 * @param codigoOrigen codigoOrigen
	 */
	public void setCodigoOrigen(String codigoOrigen) {
		this.codigoOrigen = codigoOrigen;
	}

	/**
	 * Obtiene el campo nombreFormaEnvioCastellano
	 * 
	 * @return nombreFormaEnvioCastellano
	 */
	public String getNombreFormaEnvioCastellano() {
		return this.nombreFormaEnvioCastellano;
	}

	/**
	 * Establece el campo nombreFormaEnvioCastellano
	 * 
	 * @param nombreFormaEnvioCastellano nombreFormaEnvioCastellano
	 */
	public void setNombreFormaEnvioCastellano(String nombreFormaEnvioCastellano) {
		this.nombreFormaEnvioCastellano = nombreFormaEnvioCastellano;
	}

	/**
	 * Obtiene el campo nombreFormaEnvioEuskera
	 * 
	 * @return nombreFormaEnvioEuskera
	 */
	public String getNombreFormaEnvioEuskera() {
		return this.nombreFormaEnvioEuskera;
	}

	/**
	 * Establece el campo nombreFormaEnvioEuskera
	 * 
	 * @param nombreFormaEnvioEuskera nombreFormaEnvioEuskera
	 */
	public void setNombreFormaEnvioEuskera(String nombreFormaEnvioEuskera) {
		this.nombreFormaEnvioEuskera = nombreFormaEnvioEuskera;
	}

	/**
	 * Obtiene el campo nombre en función del locale.
	 * 
	 * @param locale locale
	 * 
	 * @return nombre
	 */
	public String getNombre(Locale locale) {
		if (new Locale("eu").equals(locale)) {
			return this.nombreFormaEnvioEuskera;
		} else {
			return this.nombreFormaEnvioCastellano;
		}

	}
}
