package com.ejie.u74a.model;

import java.util.Date;
import java.util.List;

import org.hibernate.validator.constraints.Length;

/**
 * Clase auxiliar para la edición de una solicitud de material.
 * 
 *  
 */
public class FichaSolicitud {

	private static final int LENGTH_MAX_COMENTARIOS = 1000;

	/** Fecha de la solicitud. */
	private Date fechaSolicitud;

	/** Estado de la solicitud. */
	private String estado;

	/** Lista de los artículos solicitados. */
	private List<ArticuloSolicitado> articulosLst;

	/** Observaciones de la solicitud. */
	@Length(max = LENGTH_MAX_COMENTARIOS)
	private String observacionesSolicitud;

	/** Oficina origen de la solicitud. */
	private Oficina oficinaSolicitud;

	/** Lista de las ubicaciones. */
	private List<Ubicacion> ubicacionesLst;

	/** Punto de recepción de la solicitud. */
	private Ubicacion puntoRecepcion;

	/** Observaciones del punto de recepción. */
	@Length(max = LENGTH_MAX_COMENTARIOS)
	private String observacionesRecepcion;

	/**
	 * Obtiene el campo fechaSolicitud
	 * 
	 * @return fechaSolicitud
	 */
	public Date getFechaSolicitud() {
		return this.fechaSolicitud;
	}

	/**
	 * Establece el campo fechaSolicitud
	 * 
	 * @param fechaSolicitud fechaSolicitud
	 */
	public void setFechaSolicitud(Date fechaSolicitud) {
		this.fechaSolicitud = fechaSolicitud;
	}

	/**
	 * Obtiene el campo estado
	 * 
	 * @return estado
	 */
	public String getEstado() {
		return this.estado;
	}

	/**
	 * Establece el campo estado
	 * 
	 * @param estado estado
	 */
	public void setEstado(String estado) {
		this.estado = estado;
	}

	/**
	 * Obtiene el campo articulosLst
	 * 
	 * @return articulosLst
	 */
	public List<ArticuloSolicitado> getArticulosLst() {
		return this.articulosLst;
	}

	/**
	 * Establece el campo articulosLst
	 * 
	 * @param articulosLst articulosLst
	 */
	public void setArticulosLst(List<ArticuloSolicitado> articulosLst) {
		this.articulosLst = articulosLst;
	}

	/**
	 * Obtiene el campo observacionesSolicitud
	 * 
	 * @return observacionesSolicitud
	 */
	public String getObservacionesSolicitud() {
		return this.observacionesSolicitud;
	}

	/**
	 * Establece el campo observacionesSolicitud
	 * 
	 * @param observacionesSolicitud observacionesSolicitud
	 */
	public void setObservacionesSolicitud(String observacionesSolicitud) {
		this.observacionesSolicitud = observacionesSolicitud;
	}

	/**
	 * Obtiene el campo oficinaSolicitud
	 * 
	 * @return oficinaSolicitud
	 */
	public Oficina getOficinaSolicitud() {
		return this.oficinaSolicitud;
	}

	/**
	 * Establece el campo oficinaSolicitud
	 * 
	 * @param oficinaSolicitud oficinaSolicitud
	 */
	public void setOficinaSolicitud(Oficina oficinaSolicitud) {
		this.oficinaSolicitud = oficinaSolicitud;
	}

	/**
	 * Obtiene el campo ubicacionesLst
	 * 
	 * @return ubicacionesLst
	 */
	public List<Ubicacion> getUbicacionesLst() {
		return this.ubicacionesLst;
	}

	/**
	 * Establece el campo ubicacionesLst
	 * 
	 * @param ubicacionesLst ubicacionesLst
	 */
	public void setUbicacionesLst(List<Ubicacion> ubicacionesLst) {
		this.ubicacionesLst = ubicacionesLst;
	}

	/**
	 * Obtiene el campo puntoRecepcion
	 * 
	 * @return puntoRecepcion
	 */
	public Ubicacion getPuntoRecepcion() {
		return this.puntoRecepcion;
	}

	/**
	 * Establece el campo puntoRecepcion
	 * 
	 * @param puntoRecepcion puntoRecepcion
	 */
	public void setPuntoRecepcion(Ubicacion puntoRecepcion) {
		this.puntoRecepcion = puntoRecepcion;
	}

	/**
	 * Obtiene el campo observacionesRecepcion
	 * 
	 * @return observacionesRecepcion
	 */
	public String getObservacionesRecepcion() {
		return this.observacionesRecepcion;
	}

	/**
	 * Establece el campo observacionesRecepcion
	 * 
	 * @param observacionesRecepcion observacionesRecepcion
	 */
	public void setObservacionesRecepcion(String observacionesRecepcion) {
		this.observacionesRecepcion = observacionesRecepcion;
	}

}
