package com.ejie.u74a.model;

import java.util.Date;
import java.util.List;

/**
 * Clase que representa un filtro de búsqueda.
 * 
 *  
 */
public class CriteriosBusqueda {

	private String texto;
	private String tipoMaterial;
	private String tema;
	private String idioma;
	/** (S|N) a null no se tiene en cuenta para la búsqueda. */
	private String descatalogado;

	private Date fecha1;
	private Date fecha2;
	private Date fecha3;
	private Date fecha4;

	private String pendientes;
	private String aceptados;
	private String rechazados;
	private String estado;

	private Integer stockMin;
	private Integer stockMax;

	private Integer codArticulo;

	/** determina si es necesario incluir el control del stock por encima del stock mínimo */
	private String controlStock;

	/** Lista de códigos por los que filtrar */
	private List<Integer> codigos;

	// parámetros para paginación ajax
	private Integer limit; // número de registros a devolver
	private Integer offset; // indice del primer registro a devolver
	private String order; // tipo de ordenación: "asc", "desc"
	private String sort; // campo por el que se debe ordenar

	/**
	 * Obtiene el campo texto
	 * 
	 * @return texto
	 */
	public String getTexto() {
		return this.texto;
	}

	/**
	 * Establece el campo texto
	 * 
	 * @param texto texto
	 */
	public void setTexto(String texto) {
		this.texto = texto;
	}

	/**
	 * Obtiene el campo tipoMaterial
	 * 
	 * @return tipoMaterial
	 */
	public String getTipoMaterial() {
		return this.tipoMaterial;
	}

	/**
	 * Establece el campo tipoMaterial
	 * 
	 * @param tipoMaterial tipoMaterial
	 */
	public void setTipoMaterial(String tipoMaterial) {
		this.tipoMaterial = tipoMaterial;
	}

	/**
	 * Obtiene el campo tema
	 * 
	 * @return tema
	 */
	public String getTema() {
		return this.tema;
	}

	/**
	 * Establece el campo tema
	 * 
	 * @param tema tema
	 */
	public void setTema(String tema) {
		this.tema = tema;
	}

	/**
	 * Obtiene el campo idioma
	 * 
	 * @return idioma
	 */
	public String getIdioma() {
		return this.idioma;
	}

	/**
	 * Establece el campo idioma
	 * 
	 * @param idioma idioma
	 */
	public void setIdioma(String idioma) {
		this.idioma = idioma;
	}

	/**
	 * Obtiene el campo descatalogado
	 * 
	 * @return descatalogado
	 */
	public String getDescatalogado() {
		return this.descatalogado;
	}

	/**
	 * Establece el campo descatalogado
	 * 
	 * @param descatalogado descatalogado
	 */
	public void setDescatalogado(String descatalogado) {
		this.descatalogado = descatalogado;
	}

	/**
	 * Obtiene el campo fecha1
	 * 
	 * @return fecha1
	 */
	public Date getFecha1() {
		return this.fecha1;
	}

	/**
	 * Establece el campo fecha1
	 * 
	 * @param fecha1 fecha1
	 */
	public void setFecha1(Date fecha1) {
		this.fecha1 = fecha1;
	}

	/**
	 * Obtiene el campo fecha2
	 * 
	 * @return fecha2
	 */
	public Date getFecha2() {
		return this.fecha2;
	}

	/**
	 * Establece el campo fecha2
	 * 
	 * @param fecha2 fecha2
	 */
	public void setFecha2(Date fecha2) {
		this.fecha2 = fecha2;
	}

	/**
	 * Obtiene el campo fecha3
	 * 
	 * @return fecha3
	 */
	public Date getFecha3() {
		return this.fecha3;
	}

	/**
	 * Establece el campo fecha3
	 * 
	 * @param fecha3 fecha3
	 */
	public void setFecha3(Date fecha3) {
		this.fecha3 = fecha3;
	}

	/**
	 * Obtiene el campo fecha4
	 * 
	 * @return fecha4
	 */
	public Date getFecha4() {
		return this.fecha4;
	}

	/**
	 * Establece el campo fecha4
	 * 
	 * @param fecha4 fecha4
	 */
	public void setFecha4(Date fecha4) {
		this.fecha4 = fecha4;
	}

	/**
	 * Obtiene el campo pendientes
	 * 
	 * @return pendientes
	 */
	public String getPendientes() {
		return this.pendientes;
	}

	/**
	 * Establece el campo pendientes
	 * 
	 * @param pendientes pendientes
	 */
	public void setPendientes(String pendientes) {
		this.pendientes = pendientes;
	}

	/**
	 * Obtiene el campo aceptados
	 * 
	 * @return aceptados
	 */
	public String getAceptados() {
		return this.aceptados;
	}

	/**
	 * Establece el campo aceptados
	 * 
	 * @param aceptados aceptados
	 */
	public void setAceptados(String aceptados) {
		this.aceptados = aceptados;
	}

	/**
	 * Obtiene el campo rechazados
	 * 
	 * @return rechazados
	 */
	public String getRechazados() {
		return this.rechazados;
	}

	/**
	 * Establece el campo rechazados
	 * 
	 * @param rechazados rechazados
	 */
	public void setRechazados(String rechazados) {
		this.rechazados = rechazados;
	}

	/**
	 * Obtiene el campo stockMin
	 * 
	 * @return stockMin
	 */
	public Integer getStockMin() {
		return this.stockMin;
	}

	/**
	 * Establece el campo stockMin
	 * 
	 * @param stockMin stockMin
	 */
	public void setStockMin(Integer stockMin) {
		this.stockMin = stockMin;
	}

	/**
	 * Obtiene el campo stockMax
	 * 
	 * @return stockMax
	 */
	public Integer getStockMax() {
		return this.stockMax;
	}

	/**
	 * Establece el campo stockMax
	 * 
	 * @param stockMax stockMax
	 */
	public void setStockMax(Integer stockMax) {
		this.stockMax = stockMax;
	}

	/**
	 * Obtiene el campo codArticulo
	 * 
	 * @return codArticulo
	 */
	public Integer getCodArticulo() {
		return this.codArticulo;
	}

	/**
	 * Establece el campo codArticulo
	 * 
	 * @param codArticulo codArticulo
	 */
	public void setCodArticulo(Integer codArticulo) {
		this.codArticulo = codArticulo;
	}

	/**
	 * Obtiene el campo limit
	 * 
	 * @return limit
	 */
	public Integer getLimit() {
		return this.limit;
	}

	/**
	 * Establece el campo limit
	 * 
	 * @param limit limit
	 */
	public void setLimit(Integer limit) {
		this.limit = limit;
	}

	/**
	 * Obtiene el campo offset
	 * 
	 * @return offset
	 */
	public Integer getOffset() {
		return this.offset;
	}

	/**
	 * Establece el campo offset
	 * 
	 * @param offset offset
	 */
	public void setOffset(Integer offset) {
		this.offset = offset;
	}

	/**
	 * Obtiene el campo order
	 * 
	 * @return order
	 */
	public String getOrder() {
		return this.order;
	}

	/**
	 * Establece el campo order
	 * 
	 * @param order order
	 */
	public void setOrder(String order) {
		this.order = order;
	}

	/**
	 * Obtiene el campo sort
	 * 
	 * @return sort
	 */
	public String getSort() {
		return this.sort;
	}

	/**
	 * Establece el campo sort
	 * 
	 * @param sort sort
	 */
	public void setSort(String sort) {
		this.sort = sort;
	}

	/**
	 * Obtiene el campo estado
	 * 
	 * @return estado
	 */
	public String getEstado() {
		return this.estado;
	}

	/**
	 * Establece el campo estado
	 * 
	 * @param estado estado
	 */
	public void setEstado(String estado) {
		this.estado = estado;
	}

	/**
	 * Obtiene el campo controlStock
	 * 
	 * @return controlStock
	 */
	public String getControlStock() {
		return this.controlStock;
	}

	/**
	 * Establece el campo controlStock
	 * 
	 * @param controlStock controlStock
	 */
	public void setControlStock(String controlStock) {
		this.controlStock = controlStock;
	}

	/**
	 * Obtiene el campo codigos
	 * 
	 * @return codigos
	 */
	public List<Integer> getCodigos() {
		return this.codigos;
	}

	/**
	 * Establece el campo codigos
	 * 
	 * @param codigos codigos
	 */
	public void setCodigos(List<Integer> codigos) {
		this.codigos = codigos;
	}

}
