package com.ejie.u74a.model;

import java.util.Date;
import java.util.List;

import javax.validation.constraints.Digits;
import javax.validation.constraints.Min;

/**
 * Clase que representa un articulo.
 * 
 *  
 */
public class Articulo {

	private static final int MAX_DIGITS_STOCK = 6;
	private static final int MAX_DIGITS_EJEMPLARES = 6;

	/** Código del artículo. */
	private Integer codArticulo;

	/** Código del material. */
	private Integer codMaterial;

	/** Código forma de envío. */
	private Integer codigoFormaEnvio;

	/** Modo de petición E: Ejemplar; C: Caja; N: No se envía. */
	private String modoPeticion;

	/** Texto completo con el modo de petición. */
	private String descModoPeticion;

	/** Numero mínimo de ejemplares/Cajas. */
	@Min(value = 0)
	@Digits(integer = MAX_DIGITS_EJEMPLARES, fraction = 0)
	private Integer numMinimo = 0;

	/** Número ejemplares. */
	@Min(value = 0)
	@Digits(integer = MAX_DIGITS_EJEMPLARES, fraction = 0)
	private Integer numEjemplares = 0;

	/** Stock actual del articulo en la oficina. */
	@Min(value = 0)
	@Digits(integer = MAX_DIGITS_STOCK, fraction = 0)
	private Integer stock = 0;

	/** Stock anterior del articulo en la oficina, para guardar registro de Entrada - salida. */
	@Min(value = 0)
	@Digits(integer = MAX_DIGITS_STOCK, fraction = 0)
	private Integer stockAnterior = 0;

	/** Stock mínimo para que salte alarma. */
	@Min(value = 0)
	@Digits(integer = MAX_DIGITS_STOCK, fraction = 0)
	private Integer stockMin = 0;

	/** Contiene la url de la portada. */
	private String urlPortada;
	/** Contiene la url del PDF. */
	private String urlPDF;

	/** Código del almacen. */
	private String codigoAlmacen;

	/** (S|N) Indicador de artículo está descatalogado. */
	private String descatalogado;

	/** Fecha de inventario. */
	private Date fechaInventario;

	/** Fecha de entrada-salida. */
	private Date fechaEntradaSalida;

	/** Fecha de modificación del registro. */
	private Date fechaModificacion;

	/** Código de usuario que realiza la modificación. */
	private int codigoUsuarioModificador;

	// A partir de aquí vienen los campos externos.

	/** Tipo de material. */
	private TipoMaterial tipoMaterial;
	/** Material del artículo. */
	private Material material;

	/** Tema del material. */
	private TemaMaterial tema;

	/** Idioma. */
	private List<Idioma> idiomasLst;

	/** Forma de envío asociado al artículo. */
	private FormaEnvio formaEnvio;
	/** Indica el tipo de idioma, si es multilingüe, el idioma si es es monolingüe o sin idioma. */
	private String descripcionIdioma;
	/** Titulo del material ya traducido */
	private String descripcionTitulo;
	/** Nombre del tipo de material ya traducido */
	private String descripcionTipoMaterial;

	/**
	 * Obtiene el campo codArticulo
	 * 
	 * @return codArticulo
	 */
	public Integer getCodArticulo() {
		return this.codArticulo;
	}

	/**
	 * Establece el campo codArticulo
	 * 
	 * @param codArticulo codArticulo
	 */
	public void setCodArticulo(Integer codArticulo) {
		this.codArticulo = codArticulo;
	}

	/**
	 * Obtiene el campo codMaterial
	 * 
	 * @return codMaterial
	 */
	public Integer getCodMaterial() {
		return this.codMaterial;
	}

	/**
	 * Establece el campo codMaterial
	 * 
	 * @param codMaterial codMaterial
	 */
	public void setCodMaterial(Integer codMaterial) {
		this.codMaterial = codMaterial;
	}

	/**
	 * Obtiene el campo codigoFormaEnvio
	 * 
	 * @return codigoFormaEnvio
	 */
	public Integer getCodigoFormaEnvio() {
		return this.codigoFormaEnvio;
	}

	/**
	 * Establece el campo codigoFormaEnvio
	 * 
	 * @param codigoFormaEnvio codigoFormaEnvio
	 */
	public void setCodigoFormaEnvio(Integer codigoFormaEnvio) {
		this.codigoFormaEnvio = codigoFormaEnvio;
	}

	/**
	 * Obtiene el campo modoPeticion
	 * 
	 * @return modoPeticion
	 */
	public String getModoPeticion() {
		return this.modoPeticion;
	}

	/**
	 * Establece el campo modoPeticion
	 * 
	 * @param modoPeticion modoPeticion
	 */
	public void setModoPeticion(String modoPeticion) {
		this.modoPeticion = modoPeticion;
	}

	/**
	 * Obtiene el campo numMinimo
	 * 
	 * @return numMinimo
	 */
	public Integer getNumMinimo() {
		return this.numMinimo;
	}

	/**
	 * Establece el campo numMinimo
	 * 
	 * @param numMinimo numMinimo
	 */
	public void setNumMinimo(Integer numMinimo) {
		this.numMinimo = numMinimo;
	}

	/**
	 * Obtiene el campo numEjemplares
	 * 
	 * @return numEjemplares
	 */
	public Integer getNumEjemplares() {
		return this.numEjemplares;
	}

	/**
	 * Establece el campo numEjemplares
	 * 
	 * @param numEjemplares numEjemplares
	 */
	public void setNumEjemplares(Integer numEjemplares) {
		this.numEjemplares = numEjemplares;
	}

	/**
	 * Obtiene el campo stock
	 * 
	 * @return stock
	 */
	public Integer getStock() {
		return this.stock;
	}

	/**
	 * Obtiene el campo stockAnterior
	 * 
	 * @return stockAnterior
	 */
	public Integer getStockAnterior() {
		return this.stockAnterior;
	}

	/**
	 * Establece el campo stockAnterior
	 * 
	 * @param stockAnterior stockAnterior
	 */
	public void setStockAnterior(Integer stockAnterior) {
		this.stockAnterior = stockAnterior;
	}

	/**
	 * Establece el campo stock
	 * 
	 * @param stock stock
	 */
	public void setStock(Integer stock) {
		this.stock = stock;
	}

	/**
	 * Obtiene el campo urlPortada
	 * 
	 * @return urlPortada
	 */
	public String getUrlPortada() {
		return this.urlPortada;
	}

	/**
	 * Establece el campo urlPortada
	 * 
	 * @param urlPortada urlPortada
	 */
	public void setUrlPortada(String urlPortada) {
		this.urlPortada = urlPortada;
	}

	/**
	 * Obtiene el campo urlPDF
	 * 
	 * @return urlPDF
	 */
	public String getUrlPDF() {
		return this.urlPDF;
	}

	/**
	 * Establece el campo urlPDF
	 * 
	 * @param urlPDF urlPDF
	 */
	public void setUrlPDF(String urlPDF) {
		this.urlPDF = urlPDF;
	}

	/**
	 * Obtiene el campo stockMin
	 * 
	 * @return stockMin
	 */
	public Integer getStockMin() {
		return this.stockMin;
	}

	/**
	 * Establece el campo stockMin
	 * 
	 * @param stockMin stockMin
	 */
	public void setStockMin(Integer stockMin) {
		this.stockMin = stockMin;
	}

	/**
	 * Obtiene el campo codigoAlmacen
	 * 
	 * @return codigoAlmacen
	 */
	public String getCodigoAlmacen() {
		return this.codigoAlmacen;
	}

	/**
	 * Establece el campo codigoAlmacen
	 * 
	 * @param codigoAlmacen codigoAlmacen
	 */
	public void setCodigoAlmacen(String codigoAlmacen) {
		this.codigoAlmacen = codigoAlmacen;
	}

	/**
	 * Obtiene el campo descatalogado
	 * 
	 * @return descatalogado
	 */
	public String getDescatalogado() {
		return this.descatalogado;
	}

	/**
	 * Establece el campo descatalogado
	 * 
	 * @param descatalogado descatalogado
	 */
	public void setDescatalogado(String descatalogado) {
		this.descatalogado = descatalogado;
	}

	/**
	 * Obtiene el campo fechaInventario
	 * 
	 * @return fechaInventario
	 */
	public Date getFechaInventario() {
		return this.fechaInventario;
	}

	/**
	 * Establece el campo fechaInventario
	 * 
	 * @param fechaInventario fechaInventario
	 */
	public void setFechaInventario(Date fechaInventario) {
		this.fechaInventario = fechaInventario;
	}

	/**
	 * Obtiene el campo fechaEntradaSalida
	 * 
	 * @return fechaEntradaSalida
	 */
	public Date getFechaEntradaSalida() {
		return this.fechaEntradaSalida;
	}

	/**
	 * Establece el campo fechaEntradaSalida
	 * 
	 * @param fechaEntradaSalida fechaEntradaSalida
	 */
	public void setFechaEntradaSalida(Date fechaEntradaSalida) {
		this.fechaEntradaSalida = fechaEntradaSalida;
	}

	/**
	 * Obtiene el campo fechaModificacion
	 * 
	 * @return fechaModificacion
	 */
	public Date getFechaModificacion() {
		return this.fechaModificacion;
	}

	/**
	 * Establece el campo fechaModificacion
	 * 
	 * @param fechaModificacion fechaModificacion
	 */
	public void setFechaModificacion(Date fechaModificacion) {
		this.fechaModificacion = fechaModificacion;
	}

	/**
	 * Obtiene el campo codigoUsuarioModificador
	 * 
	 * @return codigoUsuarioModificador
	 */
	public int getCodigoUsuarioModificador() {
		return this.codigoUsuarioModificador;
	}

	/**
	 * Establece el campo codigoUsuarioModificador
	 * 
	 * @param codigoUsuarioModificador codigoUsuarioModificador
	 */
	public void setCodigoUsuarioModificador(int codigoUsuarioModificador) {
		this.codigoUsuarioModificador = codigoUsuarioModificador;
	}

	/**
	 * Obtiene el campo tipoMaterial
	 * 
	 * @return tipoMaterial
	 */
	public TipoMaterial getTipoMaterial() {
		return this.tipoMaterial;
	}

	/**
	 * Establece el campo tipoMaterial
	 * 
	 * @param tipoMaterial tipoMaterial
	 */
	public void setTipoMaterial(TipoMaterial tipoMaterial) {
		this.tipoMaterial = tipoMaterial;
	}

	/**
	 * Obtiene el campo material
	 * 
	 * @return material
	 */
	public Material getMaterial() {
		return this.material;
	}

	/**
	 * Establece el campo material
	 * 
	 * @param material material
	 */
	public void setMaterial(Material material) {
		this.material = material;
	}

	/**
	 * Obtiene el campo tema
	 * 
	 * @return tema
	 */
	public TemaMaterial getTema() {
		return this.tema;
	}

	/**
	 * Establece el campo tema
	 * 
	 * @param tema tema
	 */
	public void setTema(TemaMaterial tema) {
		this.tema = tema;
	}

	/**
	 * Obtiene el campo idiomasLst
	 * 
	 * @return idiomasLst
	 */
	public List<Idioma> getIdiomasLst() {
		return this.idiomasLst;
	}

	/**
	 * Establece el campo idiomasLst
	 * 
	 * @param idiomasLst idiomasLst
	 */
	public void setIdiomasLst(List<Idioma> idiomasLst) {
		this.idiomasLst = idiomasLst;
	}

	/**
	 * Obtiene el campo formaEnvio
	 * 
	 * @return formaEnvio
	 */
	public FormaEnvio getFormaEnvio() {
		return this.formaEnvio;
	}

	/**
	 * Establece el campo formaEnvio
	 * 
	 * @param formaEnvio formaEnvio
	 */
	public void setFormaEnvio(FormaEnvio formaEnvio) {
		this.formaEnvio = formaEnvio;
	}

	/**
	 * Obtiene el campo descModoPeticion
	 * 
	 * @return descModoPeticion
	 */
	public String getDescModoPeticion() {
		return this.descModoPeticion;
	}

	/**
	 * Establece el campo descModoPeticion
	 * 
	 * @param descModoPeticion descModoPeticion
	 */
	public void setDescModoPeticion(String descModoPeticion) {
		this.descModoPeticion = descModoPeticion;
	}

	/**
	 * Obtiene el campo descripcionIdioma
	 * 
	 * @return descripcionIdioma
	 */
	public String getDescripcionIdioma() {
		return this.descripcionIdioma;
	}

	/**
	 * Establece el campo descripcionIdioma
	 * 
	 * @param descripcionIdioma descripcionIdioma
	 */
	public void setDescripcionIdioma(String descripcionIdioma) {
		this.descripcionIdioma = descripcionIdioma;
	}

	/**
	 * Obtiene el campo descripcionTitulo
	 * 
	 * @return descripcionTitulo
	 */
	public String getDescripcionTitulo() {
		return this.descripcionTitulo;
	}

	/**
	 * Establece el campo descripcionTitulo
	 * 
	 * @param descripcionTitulo descripcionTitulo
	 */
	public void setDescripcionTitulo(String descripcionTitulo) {
		this.descripcionTitulo = descripcionTitulo;
	}

	/**
	 * Obtiene el campo descripcionTipoMaterial
	 * 
	 * @return descripcionTipoMaterial
	 */
	public String getDescripcionTipoMaterial() {
		return this.descripcionTipoMaterial;
	}

	/**
	 * Establece el campo descripcionTipoMaterial
	 * 
	 * @param descripcionTipoMaterial descripcionTipoMaterial
	 */
	public void setDescripcionTipoMaterial(String descripcionTipoMaterial) {
		this.descripcionTipoMaterial = descripcionTipoMaterial;
	}

}
