/*
 * Copyright 2011 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 * http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito,
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */
package com.ejie.u74a.log;

import java.util.Hashtable;

import org.slf4j.Logger;

/**
 * 
 *  
 * 
 */
public interface LoggingManager {

	/**
	 * Log. Se utiliza automáticamente por el aspecto de log.
	 * 
	 * @param args Argumentos a Loguear.
	 * @param fqnClassName Nombre de la clase
	 * @param logger logger
	 */
	public void autoLog(Hashtable<String, String> args, String fqnClassName, Logger logger);

	/**
	 * Log de incidencias.
	 * 
	 * @param fqnClassName Nombre de la clase
	 * @param logger logger
	 * @param table tabla de log
	 */
	public void logIncidences(String fqnClassName, Logger logger, Hashtable<String, String> table);
}