package com.ejie.u74a.dao;

import java.util.List;

import com.ejie.u74a.model.Ubicacion;

/**
 * Interfaz de acceso a la base de datos para obtener datos de ubicaciones. Tabla: UBICACION
 * 
 *  
 */
public interface UbicacionDao {

	/**
	 * Obtiene los datos de la ubicación dado su código.
	 * 
	 * @param codigoUbicacion el código de la ubicación.
	 * 
	 * @return Los datos de la ubicación que corresponde al código proporcionado.
	 */
	Ubicacion findByCodigo(int codigoUbicacion);

	/**
	 * Obtiene la lista de las ubicaciones asociadas a una oficina.
	 * 
	 * @param codigoOficina el código de la oficina.
	 * 
	 * @return Lista de las ubicaciones asociadas a una oficina.
	 */
	List<Ubicacion> findByCodigoOficina(String codigoOficina);

	/**
	 * Actualiza los datos de un puto de recepción
	 * 
	 * @param ubicacion datos del punto de recepción
	 * @return número de filas afectadas
	 */
	int updateUbicacion(Ubicacion ubicacion);

	/**
	 * Inserta un nuevo punto de recepción en la tabla UBICACIONES
	 * 
	 * @param ubicacion datos de la ubicación
	 * @return número de filas afectadas
	 */
	int insertUbicacion(Ubicacion ubicacion);

	/**
	 * Realiza un borrado lógico de un registro en la tabla UBICACIONES
	 * 
	 * @param codUbicacion código de la ubicación
	 * @return resultado de la operación
	 */
	int deleteLogicaUbicacion(Integer codUbicacion);

	/**
	 * Realiza un borrado físico de un registro en la tabla de UBICACIONES
	 * 
	 * @param codUbicacion código de la ubicación
	 * @return resultado de la operación
	 */
	int deleteFisicaUbicacion(Integer codUbicacion);

	/**
	 * Comprueba si una ubicación está relacionada con una petición
	 * 
	 * @param codUbicacion código de la ubicación
	 * @return true en caso de exister relación. False en caso de no existir relación
	 */
	Boolean findExisteUbicacionPeticion(Integer codUbicacion);

	/**
	 * Obtiene la lista de las ubicaciones asociadas a una oficina. (solo las activas)
	 * 
	 * @param codigoOficina el código de la oficina.
	 * 
	 * @return Lista de las ubicaciones asociadas a una oficina.
	 */
	// List<Ubicacion> findByCodigoOficinaActivos(String codigoOficina);

}
