package com.ejie.u74a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.u74a.model.TipoMaterial;

/**
 * Clase que accede a la base de datos para obtener datos de tipo de material. Tabla: TIPOMATERIAL
 * 
 *  
 */
@Repository()
@Transactional()
public class TipoMaterialDaoImpl implements TipoMaterialDao {

	private JdbcTemplate jdbcTemplate;

	/**
	 * Clase que especifica el mapeo de las columnas de la tabla TIPOMATERIAL con los objetos de la clase TipoMaterial
	 */
	private static final class TipoMaterialRowMapper implements RowMapper<TipoMaterial> {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet, int)
		 */
		@Override()
		public TipoMaterial mapRow(ResultSet rs, int rowNum) throws SQLException {

			TipoMaterial tipoMaterial = new TipoMaterial();
			tipoMaterial.setCodigo(rs.getInt("COTIPOMAT"));
			tipoMaterial.setNombreCastellano(rs.getString("NOTIPOMAT"));
			tipoMaterial.setNombreEuskera(rs.getString("NOTIPOMAT_EU"));
			tipoMaterial.setAbreviaturaCastellano(rs.getString("ABREVIATURA"));
			tipoMaterial.setAbreviaturaEuskera(rs.getString("ABREVIATURA_EU"));

			return tipoMaterial;
		}
	}

	/**
	 * Método para establecer el datasource.
	 * 
	 * @param dataSource DataSource
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.dao.TipoMaterialDao#findAll()
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<TipoMaterial> findAll() {
		StringBuilder query = new StringBuilder(
				"SELECT COTIPOMAT, NOTIPOMAT, NOTIPOMAT_EU, ABREVIATURA, ABREVIATURA_EU FROM TIPOMATERIAL ORDER BY NOTIPOMAT");
		if (new Locale("eu").equals(LocaleContextHolder.getLocale())) {
			query.append("_EU"); // Para que ordene por el nombre en euskera
		}
		return this.jdbcTemplate.query(query.toString(), new TipoMaterialRowMapper());
	}

}
