package com.ejie.u74a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.u74a.model.TemaMaterial;

/**
 * Clase que accede a la base de datos para obtener datos de temas asociados a tipos de materiales. Tabla: TEMAMATERIAL
 * 
 *  
 */
@Repository()
@Transactional()
public class TemaMaterialDaoImpl implements TemaMaterialDao {

	private JdbcTemplate jdbcTemplate;

	/**
	 * Clase que especifica el mapeo de las columnas de la tabla TEMAMATERIAL con los objetos de la clase TemaMaterial
	 */
	public static final class TemaMaterialRowMapper implements RowMapper<TemaMaterial> {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet, int)
		 */
		@Override()
		public TemaMaterial mapRow(ResultSet rs, int rowNum) throws SQLException {

			TemaMaterial temaMaterial = new TemaMaterial();

			temaMaterial.setCodigoMaterial(rs.getInt("COMATERIAL"));
			temaMaterial.setCodigoTemaMaterial(rs.getInt("COTEMAMAT"));
			temaMaterial.setCodigoTipoMaterial(rs.getInt("COTIPOMAT"));
			temaMaterial.setNombreCastellano(rs.getString("NOTEMAMAT"));
			temaMaterial.setNombreEuskera(rs.getString("NOTEMAMAT_EU"));

			return temaMaterial;
		}
	}

	/**
	 * Método para establecer el datasource.
	 * 
	 * @param dataSource DataSource
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.dao.TemaMaterialDao#findByTipoMaterial(int)
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<TemaMaterial> findByTipoMaterial(int codigoTipoMaterial) {

		StringBuilder query = new StringBuilder(
				"SELECT NULL AS COMATERIAL, COTEMAMAT, COTIPOMAT, NOTEMAMAT, NOTEMAMAT_EU FROM TEMAMATERIAL WHERE COTIPOMAT = ? ORDER BY NOTEMAMAT");
		if (new Locale("eu").equals(LocaleContextHolder.getLocale())) {
			query.append("_EU"); // Para que ordene por el nombre en euskera
		}
		return this.jdbcTemplate.query(query.toString(), new TemaMaterialRowMapper(), codigoTipoMaterial);
	}

}
