package com.ejie.u74a.dao;

import java.util.List;

import com.ejie.u74a.model.TemaMaterial;

/**
 * Interfaz de acceso a la base de datos para obtener datos de temas asociados a
 * tipos de materiales. Tabla: TEMAMATERIAL
 * 
 *  
 */
public interface TemaMaterialDao {

	/**
	 * Obtiene los temas asociados a un determinado tipo de material.
	 * 
	 * @param codigoTipoMaterial Código de tipo de material
	 * 
	 * @return lista con los temas
	 */
	List<TemaMaterial> findByTipoMaterial(int codigoTipoMaterial);

}
