package com.ejie.u74a.dao;

import java.util.List;

import com.ejie.u74a.model.CriteriosBusqueda;
import com.ejie.u74a.model.RegistroES;

/**
 * Interfaz de acceso a la base de datos para obtener datos de registros de entradas y salidas. Tabla: REGISTROES
 * 
 *  
 */
public interface RegistroEntradasSalidasDao {

	/**
	 * Obtiene la lista paginada de entradas y salidas para un código de artículo.
	 * 
	 * @param filtro {@link CriteriosBusqueda} objeto con el filtro a cumplir (codigoArticulo).
	 * @return Devuelve la lista paginada de entradas y salidas para un código de artículo.
	 */
	List<RegistroES> findByCodigo(CriteriosBusqueda filtro);

	/**
	 * Devuelve el número de entradas y salidas que tiene un código de artículo.
	 * 
	 * @param filtro {@link CriteriosBusqueda} objeto con el filtro a cumplir (codigoArticulo).
	 * @return Devuelve el número de filas afectadas.
	 */
	int findByCodigoCount(CriteriosBusqueda filtro);

	/**
	 * Inserta un nuevo registro de entrada salida.
	 * 
	 * @param registroES objeto {@link RegistroES} con la información.
	 * @return Devuelve el número de filas afectadas.
	 */
	int insertarRegistroES(RegistroES registroES);

}
