package com.ejie.u74a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.u74a.model.CriteriosBusqueda;
import com.ejie.u74a.model.RegistroES;
import com.ejie.u74a.util.Utilidades;

/**
 * Clase que accede a la base de datos de registros de entradas y salidas. Tabla: REGISTROES
 * 
 *  
 */
@Repository()
@Transactional()
public class RegistroEntradaSalidasDaoImpl implements RegistroEntradasSalidasDao {

	private JdbcTemplate jdbcTemplate;

	/**
	 * Clase que especifica el mapeo de las columnas de la tabla REGISTROES con los objetos de la clase RegistroES
	 */
	public static final class RegistroEntradaSalidasRowMapper implements RowMapper<RegistroES> {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet, int)
		 */
		@Override()
		public RegistroES mapRow(ResultSet rs, int rowNum) throws SQLException {
			RegistroES registroES = new RegistroES();

			registroES.setCodigoArticulo(rs.getInt("COARTICULO"));
			registroES.setCodigoOficina(rs.getString("COOFIORIGEN"));
			registroES.setFechaEntradaSalida(rs.getDate("FECHAES"));
			registroES.setTipo(rs.getString("TIPO"));
			registroES.setSubtipo(rs.getString("SUBTIPO"));
			registroES.setCodigoPeticion(rs.getInt("COPETICION"));
			registroES.setNumEjemplares(rs.getInt("NUEJEM"));

			registroES.setDescripcionOficina(rs.getString("T02_NOOFI"));
			return registroES;
		}
	}

	/**
	 * Método para establecer el datasource.
	 * 
	 * @param dataSource DataSource
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.dao.RegistroEntradasSalidasDao#findByCodigo(int)
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<RegistroES> findByCodigo(CriteriosBusqueda filtro) {

		StringBuilder query = new StringBuilder(
				"SELECT R.COARTICULO, R.COOFIORIGEN, R.FECHAES, R.TIPO, R.SUBTIPO, R.COPETICION, R.NUEJEM, O.T02_NOOFI ")
				.append(" FROM REGISTROES R INNER JOIN OFICINAS O ON R.COOFIORIGEN=O.T02_COOR WHERE R.COARTICULO = ? ORDER BY R.FECHAES DESC");

		// Se obtiene la consulta final incluyendo la paginación.
		StringBuilder queryFinal = new StringBuilder(Utilidades.getPaginationQuery(query, filtro.getOffset(),
				filtro.getLimit(), null, null).toString());

		return this.jdbcTemplate.query(queryFinal.toString(), new RegistroEntradaSalidasRowMapper(),
				new Object[] { filtro.getCodArticulo() });
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.dao.RegistroEntradasSalidasDao#findByCodigoCount(int)
	 */
	@Transactional(readOnly = true)
	@Override()
	public int findByCodigoCount(CriteriosBusqueda filtro) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(R.COARTICULO) FROM REGISTROES R INNER JOIN OFICINAS O ON R.COOFIORIGEN=O.T02_COOR WHERE R.COARTICULO = ?");

		return this.jdbcTemplate.queryForObject(query.toString(), new Object[] { filtro.getCodArticulo() },
				Integer.class);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.dao.RegistroEntradasSalidasDao#insertarRegistroES(RegistroES)
	 */
	@Transactional()
	@Override()
	public int insertarRegistroES(RegistroES registroES) {
		// int codigoES = this.jdbcTemplate.queryForObject("SELECT U74A55Q00.NEXTVAL FROM dual", Integer.class);
		int numAfectadas = 0;
		if (registroES.getCodigoPeticion() > 0) {
			Object[] insertObj = { registroES.getCodigoArticulo(), registroES.getCodigoOficina(),
					registroES.getFechaEntradaSalida(), registroES.getTipo(), registroES.getSubtipo(),
					registroES.getCodigoPeticion(), registroES.getNumEjemplares() };

			numAfectadas = this.jdbcTemplate
					.update("INSERT INTO REGISTROES (COARTICULO,COOFIORIGEN,FECHAES,TIPO,SUBTIPO,COPETICION,NUEJEM) VALUES (?,?,?,?,?,?,?)",
							insertObj);

		} else {
			Object[] insertObj = { registroES.getCodigoArticulo(), registroES.getCodigoOficina(),
					registroES.getFechaEntradaSalida(), registroES.getTipo(), registroES.getSubtipo(),
					registroES.getNumEjemplares() };

			numAfectadas = this.jdbcTemplate.update(
					"INSERT INTO REGISTROES (COARTICULO,COOFIORIGEN,FECHAES,TIPO,SUBTIPO,NUEJEM) VALUES (?,?,?,?,?,?)",
					insertObj);
		}

		/*
		 * if (numAfectadas > 0) { return codigoES; }
		 */
		return numAfectadas;
	}

}
