package com.ejie.u74a.dao;

import java.util.List;

import com.ejie.u74a.model.CriteriosBusqueda;
import com.ejie.u74a.model.Peticion;
import com.ejie.u74a.model.PeticionInforme;
import com.ejie.u74a.model.UbicacionInforme;

/**
 * Interfaz de acceso a la base de datos para obtener datos de peticiones. Tabla: PETICION
 * 
 *  
 */
public interface PeticionDao {

	/**
	 * Obtiene los datos de la petición correspondiente al código proporcionado.
	 * 
	 * @param codigoPeticion Código de la petición a obtener.
	 * @return objeto {@link Peticion} con los datos de la petición obtenida.
	 */
	Peticion findByCodigo(int codigoPeticion); // TODO si no se usar quitar

	/**
	 * Guarda los datos de la petición que se pasa como parámetro.
	 * 
	 * @param peticion {@link Peticion} Objeto con los datos de la petición.
	 * @return int código de la petición creada.
	 */
	int insertPeticion(Peticion peticion);

	/**
	 * Obtiene las peticiones que cumplen el filtro aplicado.
	 * 
	 * @param filtro Clase con los filtros de búsqueda.
	 * 
	 * @return lista con las peticiones
	 */
	List<Peticion> findByCriteria(CriteriosBusqueda filtro);

	/**
	 * Obtiene el número de los materiales que cumplen el filtro aplicado.
	 * 
	 * @param filtro Clase con los filtros de búsqueda.
	 * 
	 * @return int número de las peticiones que cumplen el filtro aplicado.
	 */
	int findByCountCriteria(CriteriosBusqueda filtro);

	/**
	 * Cambia el estado a una peticiones.
	 * 
	 * @param peticion datos de la peticion
	 * @return Devuelve el número de filas afectadas.
	 */
	int cambiarEstadoPeticion(Peticion peticion);

	/**
	 * Obtiene los datos relativos a la ubicación a partir del código de petición.
	 * 
	 * @param codigoPeticion Código de la petición a obtener.
	 * 
	 * @return objeto {@link UbicacionInforme} con los datos de la ubicación obtenida.
	 */
	UbicacionInforme findUbicacionByCodigo(int codigoPeticion);

	/**
	 * Obtiene los datos relativos a la petición a partir del código de petición.
	 * 
	 * @param codigoPeticion Código de la petición a obtener.
	 * 
	 * @return objeto {@link PeticionInforme} con los datos de la petición obtenida.
	 */
	PeticionInforme findPeticionInformeByCodigo(int codigoPeticion);

	/**
	 * Obtiene la lista de solicitudes realizadas por el usuario conectado
	 * 
	 * @param filtro Clase con los filtros de búsqueda.
	 * @return lista de solicitudes
	 */
	List<Peticion> findByCriteriaMisSolicitudes(CriteriosBusqueda filtro);

	/**
	 * devuelve el número de solicitudes obtenidas en la consulta
	 * 
	 * @param filtro Clase con los filtros de búsqueda.
	 * @return número de solicitudes
	 */
	int findByCountCriteriaMisSolicitudes(CriteriosBusqueda filtro);

	/**
	 * devuelve los datos completos de una petición, incluyendo los datos de la ubicación
	 * 
	 * @param codigoPeticion código de la petición a obtener
	 * @return detalle de la petición
	 */
	Peticion findDetalleByCodigo(int codigoPeticion);

}
