package com.ejie.u74a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.u74a.model.Oficina;

/**
 * Clase que accede a la base de datos para obtener datos de oficina. Tabla: OFICINAS.
 * 
 *  
 */
@Repository()
@Transactional()
public class OficinaDaoImpl implements OficinaDao {

	private JdbcTemplate jdbcTemplate;

	/**
	 * Clase que especifica el mapeo de las columnas de la tabla OFICINAS con los objetos de la clase Oficina
	 */
	private static final class OficinaRowMapper implements RowMapper<Oficina> {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet, int)
		 */
		@Override()
		public Oficina mapRow(ResultSet rs, int rowNum) throws SQLException {

			Oficina oficina = new Oficina();
			oficina.setCodigoOficina(rs.getString("T02_COOR"));
			oficina.setNombreOficina(rs.getString("T02_NOOFI"));
			oficina.setNombreContacto(rs.getString("T02_NOCON"));
			oficina.setNumeroTelefono(rs.getString("T02_NUTLF"));
			oficina.setEmail(rs.getString("T02_COEML"));

			return oficina;

			// String codigoOficina = rs.getString("T02_COOR");
			// String nombreOficina = rs.getString("T02_NOOFI");
			// String nombreContacto = rs.getString("T02_NOCON");
			// String numeroTelefono = rs.getString("T02_NUTLF");
			//
			// return new Oficina(codigoOficina, nombreOficina, nombreContacto, numeroTelefono, null, 0, null, 0, 0);
		}
	}

	/**
	 * Método para establecer el datasource.
	 * 
	 * @param dataSource DataSource
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.dao.OficinaDao#findByfindByCodigo(String)
	 */
	@Transactional(readOnly = true)
	@Override()
	public Oficina findByCodigo(String codigoOficina) {

		return this.jdbcTemplate.queryForObject(
				"SELECT T02_COOR, T02_NOOFI, T02_NOCON, T02_NUTLF, T02_COEML FROM OFICINAS O WHERE T02_COOR = ?",
				new OficinaRowMapper(), codigoOficina);
	}

}
