package com.ejie.u74a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.u74a.model.Idioma;

/**
 * Clase que accede a la base de datos para obtener datos de idioma. Tabla: IDIOMAS
 * 
 *  
 */
@Repository()
@Transactional()
public class IdiomaDaoImpl implements IdiomaDao {

	private JdbcTemplate jdbcTemplate;

	/**
	 * Clase que especifica el mapeo de las columnas de la tabla IDIOMAS con los objetos de la clase Idioma
	 */
	public static final class IdiomaRowMapper implements RowMapper<Idioma> {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet, int)
		 */
		@Override()
		public Idioma mapRow(ResultSet rs, int rowNum) throws SQLException {
			Idioma idioma = new Idioma();
			idioma.setCodigo(rs.getString("COIDIOMA"));
			idioma.setNombreCastellano(rs.getString("NOIDIOMA"));
			idioma.setNombreEuskera(rs.getString("NOIDIOMA_EU"));

			return idioma;
		}
	}

	/**
	 * Método para establecer el datasource.
	 * 
	 * @param dataSource DataSource
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.dao.IdiomaDao#findAll()
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<Idioma> findAll() {
		StringBuilder query = new StringBuilder("SELECT COIDIOMA, NOIDIOMA, NOIDIOMA_EU FROM IDIOMAS ORDER BY NOIDIOMA");
		if (new Locale("eu").equals(LocaleContextHolder.getLocale())) {
			query.append("_EU"); // Para que ordene por el nombre en euskera
		}
		return this.jdbcTemplate.query(query.toString(), new IdiomaRowMapper());
	}

}
