package com.ejie.u74a.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.u74a.model.FormaEnvio;

/**
 * Clase que accede a la base de datos para obtener datos de formas de envío. Tabla: FORMAENVIO
 * 
 *  
 */
@Repository()
@Transactional()
public class FormaEnvioDaoImpl implements FormaEnvioDao {

	private JdbcTemplate jdbcTemplate;

	/**
	 * Clase que especifica el mapeo de las columnas de la tabla FORMAENVIO con los objetos de la clase FormaEnvio
	 */
	public static final class FormaEnvioRowMapper implements RowMapper<FormaEnvio> {

		/*
		 * (non-Javadoc)
		 * 
		 * @see org.springframework.jdbc.core.RowMapper#mapRow(java.sql.ResultSet, int)
		 */
		@Override()
		public FormaEnvio mapRow(ResultSet rs, int rowNum) throws SQLException {
			FormaEnvio formaEnvio = new FormaEnvio();
			formaEnvio.setCodigoFormaEnvio(rs.getInt("COFORMAENVIO"));
			formaEnvio.setNombreFormaEnvioCastellano(rs.getString("NOFORMAENVIO"));
			formaEnvio.setNombreFormaEnvioEuskera(rs.getString("NOFORMAENVIO_EU"));
			return formaEnvio;
		}
	}

	/**
	 * Método para establecer el datasource.
	 * 
	 * @param dataSource DataSource
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.ejie.u74a.dao.FormaEnvioDao#findAll()
	 */
	@Transactional(readOnly = true)
	@Override()
	public List<FormaEnvio> findAll() {
		StringBuilder query = new StringBuilder(
				"SELECT COFORMAENVIO, NOFORMAENVIO, NOFORMAENVIO_EU FROM FORMAENVIO ORDER BY NOFORMAENVIO");
		if (new Locale("eu").equals(LocaleContextHolder.getLocale())) {
			query.append("_EU"); // Para que ordene por el nombre en euskera
		}
		return this.jdbcTemplate.query(query.toString(), new FormaEnvioRowMapper());
	}

}
