/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.autotag.core;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.tiles.autotag.core.ClassParseException;
import org.apache.tiles.autotag.core.runtime.ModelBody;
import org.apache.tiles.autotag.core.runtime.annotation.Parameter;
import org.apache.tiles.autotag.model.TemplateClass;
import org.apache.tiles.autotag.model.TemplateMethod;
import org.apache.tiles.autotag.model.TemplateParameter;
import org.apache.tiles.autotag.model.TemplateSuite;
import org.apache.tiles.autotag.model.TemplateSuiteFactory;

public class QDoxTemplateSuiteFactory
implements TemplateSuiteFactory {
    private static final String TEMPLATE_SUFFIX = "Model";
    private JavaDocBuilder builder = new JavaDocBuilder();
    private String suiteName;
    private String suiteDocumentation;
    private String requestClass;

    public QDoxTemplateSuiteFactory(File ... sourceFiles) {
        try {
            for (File file : sourceFiles) {
                this.builder.addSource(file);
            }
        }
        catch (IOException e) {
            throw new ClassParseException("I/O Exception when adding source files", e);
        }
    }

    public QDoxTemplateSuiteFactory(URL ... urls) {
        try {
            for (URL url : urls) {
                this.builder.addSource(url);
            }
        }
        catch (IOException e) {
            throw new ClassParseException("I/O Exception when adding source files", e);
        }
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    public void setSuiteDocumentation(String suiteDocumentation) {
        this.suiteDocumentation = suiteDocumentation;
    }

    public void setRequestClass(String requestClass) {
        this.requestClass = requestClass;
    }

    @Override
    public TemplateSuite createTemplateSuite() {
        ArrayList<TemplateClass> classes = new ArrayList<TemplateClass>();
        for (JavaClass clazz : this.builder.getClasses()) {
            String tagClassPrefix = this.getTagClassPrefix(clazz);
            if (tagClassPrefix == null) continue;
            String tagName = tagClassPrefix.substring(0, 1).toLowerCase() + tagClassPrefix.substring(1);
            TemplateMethod executeMethod = null;
            for (JavaMethod method : clazz.getMethods()) {
                if (!this.isFeasible(method)) continue;
                executeMethod = this.createMethod(method);
            }
            if (executeMethod == null) continue;
            TemplateClass templateClass = new TemplateClass(clazz.getFullyQualifiedName(), tagName, tagClassPrefix, executeMethod);
            templateClass.setDocumentation(clazz.getComment());
            classes.add(templateClass);
        }
        return new TemplateSuite(this.suiteName, this.suiteDocumentation, classes);
    }

    private String getTagClassPrefix(JavaClass clazz) {
        String simpleClassName = clazz.getName();
        String tagName = simpleClassName.endsWith(TEMPLATE_SUFFIX) && simpleClassName.length() > TEMPLATE_SUFFIX.length() ? simpleClassName.substring(0, 1).toUpperCase() + simpleClassName.substring(1, simpleClassName.length() - TEMPLATE_SUFFIX.length()) : null;
        return tagName;
    }

    private TemplateMethod createMethod(JavaMethod method) {
        DocletTag[] tags;
        ArrayList<TemplateParameter> params = new ArrayList<TemplateParameter>();
        for (JavaParameter parameter : method.getParameters()) {
            String exportedName = parameter.getName();
            boolean required = false;
            String defaultValue = null;
            Annotation[] annotations = parameter.getAnnotations();
            if (annotations != null && annotations.length > 0) {
                boolean found = false;
                for (int i = 0; i < annotations.length && !found; ++i) {
                    if (!Parameter.class.getName().equals(annotations[i].getType().getFullyQualifiedName())) continue;
                    found = true;
                    String candidateName = (String)annotations[i].getNamedParameter("name");
                    if (candidateName != null && candidateName.length() > 2) {
                        exportedName = candidateName.substring(1, candidateName.length() - 1);
                    }
                    required = "true".equals(annotations[i].getNamedParameter("required"));
                    candidateName = (String)annotations[i].getNamedParameter("defaultValue");
                    if (candidateName == null || candidateName.length() <= 2) continue;
                    defaultValue = candidateName.substring(1, candidateName.length() - 1);
                }
            }
            String parameterType = parameter.getType().getFullyQualifiedName();
            TemplateParameter templateParameter = new TemplateParameter(parameter.getName(), exportedName, parameterType, defaultValue, required, this.requestClass.equals(parameterType));
            params.add(templateParameter);
        }
        TemplateMethod templateMethod = new TemplateMethod(method.getName(), params);
        templateMethod.setDocumentation(method.getComment());
        for (DocletTag tag : tags = method.getTagsByName("param")) {
            TemplateParameter templateParameter;
            String[] tagParams = tag.getParameters();
            if (tagParams.length <= 0 || (templateParameter = templateMethod.getParameterByName(tagParams[0])) == null) continue;
            String tagValue = tag.getValue();
            int pos = tagValue.indexOf(" ");
            templateParameter.setDocumentation(tagValue.substring(pos).trim());
        }
        return templateMethod;
    }

    private boolean isFeasible(JavaMethod method) {
        Type returns = method.getReturns();
        if ("execute".equals(method.getName()) && returns != null && "void".equals(returns.getFullyQualifiedName()) && method.isPublic() && !method.isStatic() && !method.isAbstract() && !method.isConstructor()) {
            JavaParameter param;
            JavaParameter[] params = method.getParameters();
            if (params.length > 0 && this.requestClass.equals((param = params[params.length - 1]).getType().getFullyQualifiedName())) {
                return true;
            }
            if (params.length >= 2) {
                JavaParameter param1 = params[params.length - 2];
                JavaParameter param2 = params[params.length - 1];
                if (this.requestClass.equals(param1.getType().getFullyQualifiedName()) && ModelBody.class.getName().equals(param2.getType().getFullyQualifiedName())) {
                    return true;
                }
            }
        }
        return false;
    }
}

