/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.socket;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.messaging.Message;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.simp.annotation.support.SimpAnnotationMethodMessageHandler;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.config.annotation.web.messaging.MessageSecurityMetadataSourceRegistry;
import org.springframework.security.messaging.access.expression.MessageExpressionVoter;
import org.springframework.security.messaging.access.intercept.ChannelSecurityInterceptor;
import org.springframework.security.messaging.access.intercept.MessageSecurityMetadataSource;
import org.springframework.security.messaging.context.AuthenticationPrincipalArgumentResolver;
import org.springframework.security.messaging.context.SecurityContextChannelInterceptor;
import org.springframework.security.messaging.web.csrf.CsrfChannelInterceptor;
import org.springframework.security.messaging.web.socket.server.CsrfTokenHandshakeInterceptor;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.socket.config.annotation.AbstractWebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.server.support.WebSocketHttpRequestHandler;
import org.springframework.web.socket.sockjs.SockJsService;
import org.springframework.web.socket.sockjs.support.SockJsHttpRequestHandler;
import org.springframework.web.socket.sockjs.transport.TransportHandlingSockJsService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Order(value=-2147483548)
public abstract class AbstractSecurityWebSocketMessageBrokerConfigurer
extends AbstractWebSocketMessageBrokerConfigurer
implements SmartInitializingSingleton {
    private final WebSocketMessageSecurityMetadataSourceRegistry inboundRegistry = new WebSocketMessageSecurityMetadataSourceRegistry();
    private SecurityExpressionHandler<Message<Object>> expressionHandler;
    private ApplicationContext context;

    public void registerStompEndpoints(StompEndpointRegistry registry) {
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add((HandlerMethodArgumentResolver)new AuthenticationPrincipalArgumentResolver());
    }

    public final void configureClientInboundChannel(ChannelRegistration registration) {
        ChannelSecurityInterceptor inboundChannelSecurity = this.inboundChannelSecurity();
        registration.setInterceptors(new ChannelInterceptor[]{this.securityContextChannelInterceptor()});
        if (!this.sameOriginDisabled()) {
            registration.setInterceptors(new ChannelInterceptor[]{this.csrfChannelInterceptor()});
        }
        if (this.inboundRegistry.containsMapping()) {
            registration.setInterceptors(new ChannelInterceptor[]{inboundChannelSecurity});
        }
        this.customizeClientInboundChannel(registration);
    }

    private PathMatcher getDefaultPathMatcher() {
        try {
            return ((SimpAnnotationMethodMessageHandler)this.context.getBean(SimpAnnotationMethodMessageHandler.class)).getPathMatcher();
        }
        catch (NoSuchBeanDefinitionException e) {
            return new AntPathMatcher();
        }
    }

    protected boolean sameOriginDisabled() {
        return false;
    }

    protected void customizeClientInboundChannel(ChannelRegistration registration) {
    }

    @Bean
    public CsrfChannelInterceptor csrfChannelInterceptor() {
        return new CsrfChannelInterceptor();
    }

    @Bean
    public ChannelSecurityInterceptor inboundChannelSecurity() {
        ChannelSecurityInterceptor channelSecurityInterceptor = new ChannelSecurityInterceptor(this.inboundMessageSecurityMetadataSource());
        MessageExpressionVoter voter = new MessageExpressionVoter();
        if (this.expressionHandler != null) {
            voter.setExpressionHandler(this.expressionHandler);
        }
        ArrayList<MessageExpressionVoter> voters = new ArrayList<MessageExpressionVoter>();
        voters.add(voter);
        AffirmativeBased manager = new AffirmativeBased(voters);
        channelSecurityInterceptor.setAccessDecisionManager((AccessDecisionManager)manager);
        return channelSecurityInterceptor;
    }

    @Bean
    public SecurityContextChannelInterceptor securityContextChannelInterceptor() {
        return new SecurityContextChannelInterceptor();
    }

    @Bean
    public MessageSecurityMetadataSource inboundMessageSecurityMetadataSource() {
        if (this.expressionHandler != null) {
            this.inboundRegistry.expressionHandler(this.expressionHandler);
        }
        this.configureInbound(this.inboundRegistry);
        return this.inboundRegistry.createMetadataSource();
    }

    protected void configureInbound(MessageSecurityMetadataSourceRegistry messages) {
    }

    @Autowired
    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @Autowired(required=false)
    public void setMessageExpessionHandler(List<SecurityExpressionHandler<Message<Object>>> expressionHandlers) {
        if (expressionHandlers.size() == 1) {
            this.expressionHandler = expressionHandlers.get(0);
        }
    }

    public void afterSingletonsInstantiated() {
        if (this.sameOriginDisabled()) {
            return;
        }
        String beanName = "stompWebSocketHandlerMapping";
        SimpleUrlHandlerMapping mapping = (SimpleUrlHandlerMapping)this.context.getBean(beanName, SimpleUrlHandlerMapping.class);
        Map mappings = mapping.getHandlerMap();
        for (Object object : mappings.values()) {
            if (object instanceof SockJsHttpRequestHandler) {
                SockJsHttpRequestHandler sockjsHandler = (SockJsHttpRequestHandler)object;
                SockJsService sockJsService = sockjsHandler.getSockJsService();
                if (!(sockJsService instanceof TransportHandlingSockJsService)) {
                    throw new IllegalStateException("sockJsService must be instance of TransportHandlingSockJsService got " + sockJsService);
                }
                TransportHandlingSockJsService transportHandlingSockJsService = (TransportHandlingSockJsService)sockJsService;
                List handshakeInterceptors = transportHandlingSockJsService.getHandshakeInterceptors();
                ArrayList<CsrfTokenHandshakeInterceptor> interceptorsToSet = new ArrayList<CsrfTokenHandshakeInterceptor>(handshakeInterceptors.size() + 1);
                interceptorsToSet.add(new CsrfTokenHandshakeInterceptor());
                interceptorsToSet.addAll(handshakeInterceptors);
                transportHandlingSockJsService.setHandshakeInterceptors(interceptorsToSet);
                continue;
            }
            if (object instanceof WebSocketHttpRequestHandler) {
                WebSocketHttpRequestHandler handler = (WebSocketHttpRequestHandler)object;
                List handshakeInterceptors = handler.getHandshakeInterceptors();
                ArrayList<CsrfTokenHandshakeInterceptor> interceptorsToSet = new ArrayList<CsrfTokenHandshakeInterceptor>(handshakeInterceptors.size() + 1);
                interceptorsToSet.add(new CsrfTokenHandshakeInterceptor());
                interceptorsToSet.addAll(handshakeInterceptors);
                handler.setHandshakeInterceptors(interceptorsToSet);
                continue;
            }
            throw new IllegalStateException("Bean " + beanName + " is expected to contain mappings to either a SockJsHttpRequestHandler or a WebSocketHttpRequestHandler but got " + object);
        }
        if (this.inboundRegistry.containsMapping() && !this.inboundRegistry.isSimpDestPathMatcherConfigured()) {
            PathMatcher pathMatcher = this.getDefaultPathMatcher();
            this.inboundRegistry.simpDestPathMatcher(pathMatcher);
        }
    }

    private static class WebSocketMessageSecurityMetadataSourceRegistry
    extends MessageSecurityMetadataSourceRegistry {
        private WebSocketMessageSecurityMetadataSourceRegistry() {
        }

        public MessageSecurityMetadataSource createMetadataSource() {
            return super.createMetadataSource();
        }

        protected boolean containsMapping() {
            return super.containsMapping();
        }

        protected boolean isSimpDestPathMatcherConfigured() {
            return super.isSimpDestPathMatcherConfigured();
        }
    }
}

