// FrmkForm.js





//------------------------------------------------------- Constructor



	function FrmkForm(formUrl)

	{

		this.name = "$frmkForm" + window.document.forms.length + 1;

		this.htmlCode = this.getPostForm(formUrl);		

	}





//------------------------------------------------------- Metodos de clase



	/**

	 * Descripcion: convierte un submit de tipo GET en uno de tipo POST.

	 *				Para ello crea (o actualiza si ya existe) un formulario

	 *				con metodo POST y tantos hijos como parametros tenga

	 *				la url que recive.

	 * Utilizado en: TableTag

	 */ 

	FrmkForm.prototype.getPostForm = function(formUrl)

	{ 	

		var formCode = "";

		var u = formUrl || "";

		if (u!=null && u.length!=0) {

			var pairs = u.substring(u.indexOf('?')+1).split('&'); 

			u = u.substring(0,u.indexOf('?')); 

			var childArray; 

			for (var i=0;i<pairs.length;i++) { 

				var pos = pairs[i].indexOf('='); 

				if (pos >= 0) { 

					var name = pairs[i].substring(0,pos); 

					var value = pairs[i].substring(pos+1); 

					if(childArray) childArray[childArray.length]=[name, value]; 

					else childArray = [[name, value]]; 

				} 

			} 

			

			formCode =  this.getCode(u,childArray);

		}

		return formCode;

	} 							 	



	/** 

	 *  Devuelve el codigo html para generar el formulario 

	 */

	FrmkForm.prototype.getCode = function (formUrl,childArray)

	{ 

		var htmlCode = '<form id="'+this.name+'" name="'+this.name+'" action="'+formUrl+'" method="POST">';

		if (childArray!=null) {

			for(var i=0; i < childArray.length; i++) { 

				htmlCode += '<input name="'+childArray[i][0]+'" value="'+childArray[i][1]+'" type="hidden">';

			}

		}

		htmlCode += '</form>';

		return htmlCode;

	} 	