package q02b.procesos.operacionesinternas;



import java.util.ArrayList;

import java.util.HashMap;



import q02b.exe.comun.valueobjects.Q02bCodigoValor;

import q02b.exe.operacioninterna.Q02bOperacionInterna;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;

import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;



public class Q02bOITratarListasConsultaProceso extends Q02bOperacionInterna {

	

	private static Q70Traza tr = Q70Traza.getSingleton();

	protected static final String COMPONENTE = "OPERACION_INTERNA";

	

	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto,Q70OperacionInternaConfigBean configuracion,

			Q70OperacionInternaErrors errores)

			throws Exception {

		

		try{

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":preProcessMappingEntrada: entrando");

			}

			contexto.set("listaRolesSeleccionados",new String[0]);

			contexto.set("listaRolesAsignados",new Q02bCodigoValor[0]);

			contexto.set("listaRoles",new Q02bCodigoValor[0]);

			

		}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":preProcessMappingEntrada: " + sw.getBuffer ().toString());

	        throw ex;

		}finally {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":preProcessMappingEntrada: saliendo.");

			}

		}

	}

	

	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errores)

		throws Exception {

		try{

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":postProcessMappingSalida: entrando");

			}

			Q02bCodigoValor[] listaRolesAsignados = new Q02bCodigoValor[0];

			Q02bCodigoValor[] listaRoles = new Q02bCodigoValor[0];

			

			HashMap mapaProceso = (HashMap)contexto.get("proceso");

			

			ArrayList listaRolesSeleccionados = (ArrayList)mapaProceso.get("listaRolesSeleccionados");

			ArrayList listaRolesNoSeleccionados = (ArrayList)mapaProceso.get("listaRoles");

			

			if (null!=listaRolesSeleccionados && listaRolesSeleccionados.size()>0){

				listaRolesAsignados = (Q02bCodigoValor[])listaRolesSeleccionados.toArray(new Q02bCodigoValor[listaRolesSeleccionados.size()]);

			}

			if (null!=listaRolesNoSeleccionados && listaRolesNoSeleccionados.size()>0){

				listaRoles = (Q02bCodigoValor[])listaRolesNoSeleccionados.toArray(new Q02bCodigoValor[listaRolesNoSeleccionados.size()]);

			}

			

			contexto.set("listaRolesAsignados",listaRolesAsignados);

			contexto.set("listaRoles",listaRoles);

	

		}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":postProcessMappingSalida: " + sw.getBuffer ().toString());

	        throw ex;

		}finally {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":postProcessMappingSalida: saliendo.");

			}

		}

	}

}